package de.ugoe.cs.swe.bnftools.ui.refactoring.autorenumber;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry;

public class AutoRenumberRefactoringProcessor extends RefactoringProcessor {
	IFile file;
	private CompositeNode rootNode;
	private XtextDocument document;
	
	// ----------------------------------------------------------------------------------------------------

	public AutoRenumberRefactoringProcessor(XtextEditor editor, CompositeNode root, XtextDocument doc) {
		file = (IFile) editor.getEditorInput().getAdapter(IFile.class);
		this.rootNode = root;
		this.document = doc;
	}
	
	// ----------------------------------------------------------------------------------------------------

	@Override
	public Object[] getElements() {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getIdentifier() {
		return "Autorenumbering Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getProcessorName() {
		return "Autorenumbering Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public boolean isApplicable() throws CoreException {
		return (rootNode != null);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkInitialConditions(IProgressMonitor pm)
			throws CoreException, OperationCanceledException {
		
		RefactoringStatus status = new RefactoringStatus();

		if (rootNode == null)
			status.addFatalError("Root node is null!");

		return status;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkFinalConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws CoreException,
			OperationCanceledException {
		
		return checkInitialConditions(pm);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {
		/*
		 * Create a change, initialise the IProgressMonitor with 2 task:
		 * 1. renaming the reference with the rule's right side
		 * 2. renaming the whole rule with an empty string
		 */
		CompositeChange compositeChange = new CompositeChange("Autorenumbering");
		pm.beginTask("Autorenumbering Refactoring", 2);
		
		//initialising the edit
		MultiTextEdit multiEdit = new MultiTextEdit();
		TextFileChange fileChange = new TextFileChange("Autorenumbering", file);
		fileChange.setEdit(multiEdit);
		fileChange.setTextType("bnf");
		compositeChange.add(fileChange);
		
		int counter = 1;
		// renumber the rules
		for (int i=0; i < rootNode.getChildren().size(); i++) {
			AbstractNode child = rootNode.getChildren().get(i);
			EObject element = child.getElement();
			if (!(element instanceof BnfEntry))
				continue;
			BnfEntry bnfEntry = (BnfEntry) element;
			if (bnfEntry.getRule() == null)
				continue;
			
			child = NodeUtil.getNodeAdapter(bnfEntry.getRule()).getParserNode();
			
			String ruleText;
			try {
				ruleText = document.get(child.getOffset(), child.getLength());
				int numberSeperatorPosition = ruleText.indexOf(".");
				if (numberSeperatorPosition >= 0) {
					int startOffset = child.getOffset();
					int length = numberSeperatorPosition;
					
					ReplaceEdit replaceEdit = new ReplaceEdit(startOffset, length, Integer.toString(counter));
					multiEdit.addChild(replaceEdit);
					TextEditGroup editGroup2 = new TextEditGroup("renumbering", replaceEdit);
					fileChange.addTextEditGroup(editGroup2);
					pm.worked(1);
				}
				counter++;
			} catch (BadLocationException e) {
				e.printStackTrace();
			}
		}
		
		return compositeChange;
		
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringParticipant[] loadParticipants(RefactoringStatus status,
			SharableParticipants sharedParticipants) throws CoreException {
		return null;
	}

}