package de.ugoe.cs.swe.bnftools.ui.syntaxcoloring;

import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightedPositionAcceptor;
import org.eclipse.xtext.ui.editor.syntaxcoloring.ISemanticHighlightingCalculator;

import de.ugoe.cs.swe.bnftools.analysis.EbnfAnalysisUtils;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;

public class EtsiBnfSemanticHighlightingCalculator implements
		ISemanticHighlightingCalculator {

	public void provideHighlightingFor(XtextResource resource,
			IHighlightedPositionAcceptor acceptor) {

		if (resource == null)
			return;

		Iterable<AbstractNode> allNodes = NodeUtil.getAllContents(resource
				.getParseResult().getRootNode());
		
		for (AbstractNode node : allNodes) {
			if (node.getGrammarElement() instanceof CrossReference) {
				acceptor.addPosition(node.getOffset(), node.getLength(),
						EtsiBnfHighlightingConfiguration.CROSSREF_ID);
			} else if (node.getElement() instanceof Rule) {
				Rule rule = (Rule) node.getElement();
				
				int dividerPosition = 0;
				for (int i = 0; i < node.getLeafNodes().size(); i++) {
					LeafNode currentNode = node.getLeafNodes().get(i);
					if (currentNode.getText().equals(rule.getName())) {
						dividerPosition = currentNode.getOffset()
								+ currentNode.getLength();
						break;
					}
				}
				int length = dividerPosition - node.getOffset();
				if (length > 0) {
					if (EbnfAnalysisUtils.isTokenRule(rule)) {
						acceptor.addPosition(node.getOffset(), length,
								EtsiBnfHighlightingConfiguration.TOKENRULE_ID);
					} else {
						acceptor.addPosition(node.getOffset(), length,
								EtsiBnfHighlightingConfiguration.RULENAME_ID);
					}
				}
			}
		}

	}

}
