package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.geometry.Insets;

public class LineMarginBorder extends LineBorder {
	private Insets insets;
	private int borderWidth;

	public LineMarginBorder(int horizontal, int vertical, int borderWidth) {
		super(borderWidth);
		insets = new Insets(vertical, horizontal, vertical, horizontal);
		this.borderWidth = borderWidth;
	}

	public LineMarginBorder(int top, int left, int bottom, int right,
			int borderWidth) {
		super(borderWidth);
		insets = new Insets(top, left, bottom, right);
		this.borderWidth = borderWidth;
	}

	public Insets getInsets(IFigure figure) {
		return insets;
	}

	public void paint(IFigure figure, Graphics graphics, Insets insets) {
		if (borderWidth > 0) {
			tempRect.setBounds(getPaintRectangle(figure, insets));
			if (getWidth() % 2 == 1) {
				tempRect.width--;
				tempRect.height--;
			}
			tempRect.shrink(getWidth() / 2, getWidth() / 2);
			graphics.setLineWidth(getWidth());
			graphics.setLineStyle(getStyle());
			if (getColor() != null)
				graphics.setForegroundColor(getColor());
			graphics.drawRectangle(tempRect);
		}
	}

}
