package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ToolbarLayout;

public class SyntaxDiagram extends SyntaxDiagramFigure {
	private SyntaxDiagramFigure lastFigure = null;

	public SyntaxDiagram() {
		ToolbarLayout contentsLayout = new ToolbarLayout();
		contentsLayout.setSpacing(20);
		contentsLayout.setVertical(false);
		contentsLayout.setStretchMinorAxis(false);
		contentsLayout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
//		setForegroundColor(ColorConstants.darkGreen);
//		setBorder(new LineBorder());
		setLayoutManager(contentsLayout);
		setBackgroundColor(ColorConstants.white);
		setOpaque(true);
	}

	public void addSyntaxFigure(SyntaxDiagramFigure f) {
		
		if (lastFigure != null) {
			PathFigure sequenceConnectionPath = new PathFigure();
			sequenceConnectionPath.setTargetDecoration(null);
			sequenceConnectionPath.setSourceAnchor(lastFigure.getRightAnchor());
			sequenceConnectionPath.setTargetAnchor(f.getLeftAnchor());
			add(sequenceConnectionPath);
		} else {
			PathFigure sequenceConnectionPath = new PathFigure();
			sequenceConnectionPath.setTargetDecoration(null);
			sequenceConnectionPath.setSourceAnchor(getLeftAnchor());
			sequenceConnectionPath.setTargetAnchor(f.getLeftAnchor());
			add(sequenceConnectionPath);
		}
		
		add(f);
		lastFigure  = f;
	}
	
	public void finish() {
		if (lastFigure != null) {
			PathFigure sequenceConnectionPath = new PathFigure();
			sequenceConnectionPath.setSourceAnchor(lastFigure.getRightAnchor());
			sequenceConnectionPath.setTargetAnchor(getRightAnchor());
			add(sequenceConnectionPath);
		}
	}
}
