package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parsetree.NodeAdapter;

import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;

public class SyntaxDiagramCreator {

	private NodeAdapter node;

	public SyntaxDiagramCreator(NodeAdapter node) {
		this.node = node;
	}
	
	public SyntaxDiagramFigure createSyntaxDiagram() {
		if (node == null) 
			return new SyntaxDiagramFigure();

		EObject ruleRoot = (EObject) node.getParserNode().getElement();
		
		SyntaxDiagramFigure syntaxDiagramFigure = create(ruleRoot);
		
		return syntaxDiagramFigure;
	}
	
	private SyntaxDiagramFigure create(EObject o) {
		if (o instanceof Rule) {
			SyntaxDiagramFigure f = create(o.eContents().get(0));
			return f;
		} else if (o instanceof DefinitionList) {
			if (o.eContents().size() == 1) {
				SyntaxDiagramFigure f = create(o.eContents().get(0));
				return f;
			} else {
				AlternativeFigure af = new AlternativeFigure();
				for (int i=0; i < o.eContents().size();i++) {
					SyntaxDiagramFigure f = create(o.eContents().get(i));
					if (f != null)
						af.addSyntaxFigure(f);
				}
				return af;
			}
		} else if (o instanceof SingleDefinition) {
			SyntaxDiagram outer = new SyntaxDiagram();
			for (int i=0; i < o.eContents().size();i++) {
				SyntaxDiagramFigure f = create(o.eContents().get(i));
				if (f != null)
					outer.addSyntaxFigure(f);
			}
			outer.finish();
			return outer;
		} else if (o instanceof GroupedSequence) {
			SyntaxDiagram syntaxDiagram = new SyntaxDiagram();
			for (int i=0; i < o.eContents().size();i++) {
				SyntaxDiagramFigure f = create(o.eContents().get(i));
				if (f != null)
					syntaxDiagram.addSyntaxFigure(f);
			}
			return syntaxDiagram;
		} else if (o instanceof OptionalSequence) {
			SyntaxDiagram syntaxDiagram = new SyntaxDiagram();
			for (int i=0; i < o.eContents().size();i++) {
				SyntaxDiagramFigure f = create(o.eContents().get(i));
				if (f != null)
					syntaxDiagram.addSyntaxFigure(f);
			}
			OptionFigure af = new OptionFigure(syntaxDiagram);
			syntaxDiagram.finish();
			return af;
		} else if (o instanceof RepeatedSequence) {
			RepeatedSequence e = (RepeatedSequence) o;
			SyntaxDiagram syntaxDiagram = new SyntaxDiagram();
			for (int i=0; i < o.eContents().size();i++) {
				SyntaxDiagramFigure f = create(o.eContents().get(i));
				if (f != null)
					syntaxDiagram.addSyntaxFigure(f);
			}
			if (e.isMorethanonce()) {
				RepetitionFigure rf = new RepetitionFigure(syntaxDiagram);
				syntaxDiagram.finish();
				return rf;
			} else {
				OptionRepetitionFigure rf = new OptionRepetitionFigure(syntaxDiagram);
				syntaxDiagram.finish();
				return rf;
			}
		} else if (o instanceof de.ugoe.cs.swe.bnftools.ebnf.StringRule) {
			de.ugoe.cs.swe.bnftools.ebnf.StringRule e = (de.ugoe.cs.swe.bnftools.ebnf.StringRule) o;
			if (e.getColon() != null)
				return new TerminalFigure(e.getColon());
			else
				return new TerminalFigure(e.getLiteral());
			
		} else if (o instanceof RuleReference) {
			RuleReference e = (RuleReference) o;
			return new NonTerminalFigure(e.getRuleref().getName());
		} else {
			return create(o.eContents().get(0));
		}
		
//		return null;
	}
	
}
