/*
 * generated by Xtext
 */
package de.ugoe.cs.swe.bnftools.generator

import org.eclipse.emf.ecore.resource.Resource
import org.eclipse.xtext.generator.IGenerator
import org.eclipse.xtext.generator.IFileSystemAccess
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf
import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry
import de.ugoe.cs.swe.bnftools.ebnf.Rule
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition
import de.ugoe.cs.swe.bnftools.ebnf.Term
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence
import de.ugoe.cs.swe.bnftools.ebnf.Atom
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference
import de.ugoe.cs.swe.bnftools.ebnf.StringRule
import java.io.File
import org.eclipse.xtext.generator.IFileSystemAccessExtension2
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccessExtension
import java.io.PrintWriter

/**
 * Generates code from your model files on save.
 * 
 * see http://www.eclipse.org/Xtext/documentation.html#TutorialCodeGeneration
 */
class EbnfGenerator implements IGenerator {

	//generation of the xsl-file
	override void doGenerate(Resource resource, IFileSystemAccess fsa) {
		var String workspacePath = WorkspaceResolver.getWorkspace();
		for (e : resource.allContents.toIterable.filter(EtsiBnf)) {
			if (e.bnfEntry.size != 0) {
				fsa.generateFile(e.name + ".fo", e.compile)

				//generate pdf
				var uri = (fsa as IFileSystemAccessExtension2).getURI(e.name + ".fo");
				var String fullUri = workspacePath + uri.path.substring(10, uri.path.length);
				System.out.println(workspacePath + uri.path.substring(10, uri.path.length));
				var File file = new File(fullUri);
				System.out.println(file.exists+ "," + fullUri.substring(0, fullUri.length - 3));

				if (file.exists) {
					foToPdf.createPdfFromFo(fullUri.substring(0, fullUri.length - 3));
				}
			}
		}
	}

	// compile the different entities of the Bnf-----------------------------------------------------------------------------
	def compile(EtsiBnf bnf) '''
	<?xml version="1.0"?>
	<!-- fop «bnf.name».xml -rtf «bnf.name».rtf -->
	<fo:root xmlns:fo="http://www.w3.org/1999/XSL/Format">
	
		<fo:layout-master-set>
		 		<fo:simple-page-master master-name="A4" page-width="210mm" page-height="297mm">
		 				<fo:region-body region-name="xsl-region-body"  margin="2cm"/>
		 				</fo:simple-page-master>
		</fo:layout-master-set>
	
		<fo:page-sequence  master-reference="A4">
			<fo:flow flow-name="xsl-region-body" font-family="verdana">
				
				<fo:block span="all"  text-align="center" text-indent="1em" font-family="Arial" font-size="20pt" font-weight="bold" background-color="#EEEEEE" line-height="20mm">«bnf.
		name»</fo:block>
						
				«FOR bnfentry : bnf.bnfEntry»
					«bnfentry.compile»
				«ENDFOR»
			</fo:flow>
		</fo:page-sequence>
	</fo:root>'''

	def compile(BnfEntry bnfEntry) '''
		«IF bnfEntry.rule != null»
			«bnfEntry.rule.compile»
		«ENDIF»
	'''

	def compile(Rule rule) '''<fo:block><fo:inline id="«rule.name»"	color="purple">«IF rule.rulenumber != 0»«rule.
		rulenumber».	«ENDIF»«rule.name»</fo:inline>	::=	«rule.definitionList.compile»</fo:block>'''

	def compile(DefinitionList dList) '''«FOR sDef : dList.singleDefinition»«sDef.compile»«IF !sDef.equals(
		dList.singleDefinition.last)» | «ENDIF»«ENDFOR»'''

	def compile(SingleDefinition sDefinition) '''«FOR term : sDefinition.terms»«term.compile»«ENDFOR»'''

	def compile(Term term) '''«IF term.termAtom != null»«term.termAtom.compile»«ENDIF»«IF term.termOptionalSequence !=
		null»«term.termOptionalSequence.compile»«ENDIF»«IF term.termRepeatedSequence != null»«term.termRepeatedSequence.
		compile»«ENDIF»«IF term.termGroupedSequence != null»«term.termGroupedSequence.compile»«ENDIF»'''

	def compile(GroupedSequence gSequ) '''«FOR d : gSequ.definitionList»«d.compile»«ENDFOR»'''

	def compile(RepeatedSequence rSequ) '''{«FOR d : rSequ.definitions»«d.compile»«ENDFOR»}«IF rSequ.morethanonce»+«ENDIF»'''

	def compile(OptionalSequence oSequ) '''(«FOR d : oSequ.definitionList»«d.compile»«ENDFOR»)'''

	def compile(Atom atom) '''
	«IF atom.atomRuleReference != null»«atom.atomRuleReference.compile»«ENDIF»«IF atom.atomStringRule != null»«atom.
		atomStringRule.compile»«ENDIF»'''

	def compile(RuleReference rRef) '''<fo:basic-link internal-destination="«rRef.ruleref.name»" text-decoration="underline" color="blue">«rRef.
		ruleref.name»</fo:basic-link>	'''

	def compile(StringRule sRule) '''«IF sRule.colon != null»«sRule.colon»«ENDIF»«IF sRule.literal != null»«sRule.
		literal»	«ENDIF»'''

}
