package de.ugoe.cs.swe.bnftools.ui.formatter;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Import;

import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.MergeRule;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;
import de.ugoe.cs.swe.bnftools.visitor.EbnfVisitor;

public class EbnfFormatterVisitor extends EbnfVisitor {
	private StringBuffer buf;
	private FormatterConfig config;

	public EbnfFormatterVisitor(EObject rootNode, FormatterConfig config) {
		super(rootNode);
		this.config = config;
		buf = new StringBuffer();
	}

	public EbnfFormatterVisitor(FormatterConfig config) {
		this.config = config;
		buf = new StringBuffer();
	}

	public StringBuffer getBuf() {
		return buf;
	}

	// -----------------------------------------------------------------------------

	protected void visitBefore(EtsiBnf node) {
		buf.append("grammar " + node.getName());
		if (node.getType() != null)
			buf.append(node.getType());
		buf.append(";");
		buf.append("\n\n");
	}

	protected void visitAfter(EtsiBnf node) {
	}

	protected void visitBefore(Atom node) {
	}

	protected void visitAfter(Atom node) {
	}

	protected void visitBefore(Term node) {
	}

	protected void visitAfter(Term node) {
		SingleDefinition parent = (SingleDefinition) node.eContainer();
		int index = parent.getTerms().indexOf(node);
		if ((parent.getTerms().size() > 0) && (index < parent.getTerms().size()-1))
			buf.append(" ");
	}

	protected void visitBefore(DefinitionList node) {
	}

	protected void visitAfter(DefinitionList node) {
	}

	protected void visitBefore(ExtRule node) {
	}

	protected void visitAfter(ExtRule node) {
	}

	protected void visitBefore(GlobalCombinator node) {
	}

	protected void visitAfter(GlobalCombinator node) {
	}

	protected void visitBefore(GroupedSequence node) {
		buf.append("(");
	}

	protected void visitAfter(GroupedSequence node) {
		buf.append(")");
	}

	protected void visitBefore(HookCombinator node) {
	}

	protected void visitAfter(HookCombinator node) {
	}

	protected void visitBefore(Import node) {
	}

	protected void visitAfter(Import node) {
	}

	protected void visitBefore(MergeRule node) {
	}

	protected void visitAfter(MergeRule node) {
	}

	protected void visitBefore(OptionalSequence node) {
	}

	protected void visitAfter(OptionalSequence node) {
	}

	protected void visitBefore(RepeatedSequence node) {
	}

	protected void visitAfter(RepeatedSequence node) {
	}

	protected void visitBefore(Rule node) {
		if (node.getRulenumber() > 0)
			buf.append(node.getRulenumber() + ". ");
		
		buf.append(node.getName() + " ::= ");
	}

	protected void visitAfter(Rule node) {
		buf.append(";\n");
	}

	protected void visitBefore(RuleCombinator node) {
	}

	protected void visitAfter(RuleCombinator node) {
	}

	protected void visitBefore(RuleReference node) {
	}

	protected void visitAfter(RuleReference node) {
	}

	protected void visitBefore(SectionHeading node) {
	}

	protected void visitAfter(SectionHeading node) {
	}

	protected void visitBefore(SingleDefinition node) {
	}

	protected void visitAfter(SingleDefinition node) {
	}

	protected void visitBefore(StringRule node) {
		if (node.getLiteral() != null)
			buf.append("\"" + node.getLiteral() + "\"");
		else if (node.getColon() != null)
			buf.append(" " + node.getColon());
	}

	protected void visitAfter(StringRule node) {
	}

	
	
}
