package de.ugoe.cs.swe.bnftools.ui.refactoring.removeunusedrules;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import com.google.inject.Inject;

import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ui.quickfix.processors.RemoveUnusedRulesProcessor;
import de.ugoe.cs.swe.bnftools.ui.refactoring.generic.GenericRefactoring;
import de.ugoe.cs.swe.bnftools.ui.refactoring.generic.GenericRefactoringWizard;
import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;
import de.ugoe.cs.swe.bnftools.utils.Utils;

public class RemoveUnusedRulesRefactoringHandler extends AbstractHandler {

	@Inject
	IResourceDescriptions resourceDescriptions;

	public Object execute(ExecutionEvent event) throws ExecutionException {
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage().getActiveEditor();

//TODO: better error handling		
		if (!(editor.getDocument() instanceof XtextDocument)) {
			return null;
		}
		
		XtextDocument doc = (XtextDocument) editor.getDocument();
		EObject root = doc.readOnly(new RootEObjectFinder());
		NodeAdapter rootNode = NodeUtil.getNodeAdapter(root);

		List<CompositeNode> unusedRules = new ArrayList<CompositeNode>();
		
		int counter = 0;
		for (int i=0; i < rootNode.getParserNode().getChildren().size(); i++) {
			AbstractNode currentNode = rootNode.getParserNode().getChildren().get(i);
			
			EObject element = currentNode.getElement();
			if (!(element instanceof BnfEntry))
				continue;
			BnfEntry bnfEntry = (BnfEntry) element;
			if (bnfEntry.getRule() == null)
				continue;
			
			currentNode = NodeUtil.getNodeAdapter(bnfEntry.getRule()).getParserNode();
			
			if (currentNode.getElement() instanceof Rule) {
				Rule rule = (Rule) currentNode.getElement();
				NodeAdapter declarationNode = NodeUtil.getNodeAdapter(rule);
				List<CompositeNode> references = Utils.findReferences(rule,
							resourceDescriptions, editor);

				if ((references.size() == 0) && (counter > 0)){
					unusedRules.add(declarationNode.getParserNode());
				}
				counter++;
			}
		}

		RemoveUnusedRulesProcessor processor = new RemoveUnusedRulesProcessor(
				editor, editor.getDocument(), unusedRules);
		
		GenericRefactoring refactoring = new GenericRefactoring(processor);
		
		GenericRefactoringWizard wizard = new GenericRefactoringWizard(
				refactoring, RefactoringWizard.WIZARD_BASED_USER_INTERFACE);

		RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation(
				wizard);

		try {
			openOperation.run(Display.getCurrent().getActiveShell(),
					"Refactoring not possible!");
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}

		
		return null;
	}

}
