package de.ugoe.cs.swe.bnftools.ui.formatter;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parsetree.LeafNode;

import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;

public class EbnfHtmlFormatterVisitor extends EbnfFormatterVisitor {

	private ArrayList<MetaTextEntry> metaTexts = new ArrayList<MetaTextEntry>();
	
	public EbnfHtmlFormatterVisitor(EObject rootNode, FormatterConfig config) {
		super(rootNode, config);
		this.config = config;
		buf = new StringBuffer();
	}

	protected void weaveComments() {
		bufferPositionOriginalText = 0;
		bufferPositionFormattedTextNoWhitespaces = 0;
		bufferPositionFormattedText = 0;
		
		StringBuffer result = new StringBuffer();
		formattedTextNoWhitespaces = buf.toString().replaceAll("[ \t\n\r]", "");
		formattedText = buf.toString();

		MetaTextEntry currentMetaText = null;
		if (metaTexts.iterator().hasNext())
			currentMetaText = metaTexts.iterator().next();

		while (bufferPositionFormattedTextNoWhitespaces <= formattedTextNoWhitespaces.length()) {
			skipWhitespacesOriginalText();
			skipWhitespacesFormattedText(result);
			
			if (!(bufferPositionOriginalText < originalText.length()))
				break;
			
			char formattedPositionNoWhitespaces;
			if (bufferPositionFormattedTextNoWhitespaces == formattedTextNoWhitespaces.length()) {
				formattedPositionNoWhitespaces = ' ';
			} else {
				formattedPositionNoWhitespaces = formattedTextNoWhitespaces.charAt(bufferPositionFormattedTextNoWhitespaces);
			}
			char originalPosition = originalText.charAt(bufferPositionOriginalText);
			
			if (formattedPositionNoWhitespaces != originalPosition) {
				if (formattedPositionNoWhitespaces == ';') { // formatted text always outputs the optional semicolon, skip it if necessary
					bufferPositionFormattedTextNoWhitespaces++;
					bufferPositionFormattedText++;
				} else if (isCommentNext(originalText, bufferPositionOriginalText)) {
					LeafNode currentComment = allComments.get(allCommentsPosition); 
					if (currentComment.getTotalOffset() == bufferPositionOriginalText) {
						if (isMultiLineComment(currentComment.getText())) {
							int newLinesCount = scanBackNewlinesCount(originalText, bufferPositionOriginalText-1);
							if (newLinesCount > 0) {
								if (scanBackNewlinesCount(result.toString(), result.toString().length()-1) == 0) {
									result.append("\n\n");
								}
								
								result.append(currentComment.getText());
								result.append("\n");
							} else {
								String lastWhiteSpaces = scanBackWhitespaces(result.toString(), result.toString().length()-1);
								result.delete(result.toString().length() - lastWhiteSpaces.length(), result.toString().length());
								result.append(" " + stripEndingNewline(currentComment.getText()));
								result.append(lastWhiteSpaces);
							}
						} else if (isSingleLineComment(currentComment.getText())) {
							int newLinesCount = scanBackNewlinesCount(originalText, bufferPositionOriginalText-1);
							String lastWhiteSpaces = scanBackWhitespaces(result.toString(), result.toString().length()-1);
							result.delete(result.toString().length() - lastWhiteSpaces.length(), result.toString().length());
							if (newLinesCount > 0) {
								result.append("\n\n" + stripEndingNewline(currentComment.getText()));
							} else {
								result.append(" " + stripEndingNewline(currentComment.getText()));
							}
							result.append(lastWhiteSpaces);
						}
						bufferPositionOriginalText+=currentComment.getLength();
						allCommentsPosition++;
					}
				} else { // disaster handling: return original unformatted text!
					System.err.println("Disaster Recovery: returning original text!!");
					buf = new StringBuffer();
					buf.append(originalText);
					return;
				}
			} else {
				if ((currentMetaText != null) && (bufferPositionFormattedText >= currentMetaText.getOffset())) {
					result.append(currentMetaText.getText());
					metaTexts.remove(currentMetaText);
					if (metaTexts.iterator().hasNext())
						currentMetaText = metaTexts.iterator().next();
					else
						currentMetaText = null;
				}
				
				result.append(formattedText.substring(bufferPositionFormattedText, bufferPositionFormattedText+1));
				bufferPositionOriginalText++;
				bufferPositionFormattedText++;
				bufferPositionFormattedTextNoWhitespaces++;
				
				if ((currentMetaText != null) && (bufferPositionFormattedText >= currentMetaText.getOffset())) {
					result.append(currentMetaText.getText());
					metaTexts.remove(currentMetaText);
					if (metaTexts.iterator().hasNext())
						currentMetaText = metaTexts.iterator().next();
					else
						currentMetaText = null;
				}
			}
		}
		buf = result;
	}
	
	protected void metaText(String str) {
		MetaTextEntry metaTextEntry = new MetaTextEntry(str, buf.length());
		metaTexts.add(metaTextEntry);
	}

	// -----------------------------------------------------------------------------
	
	protected void visitBefore(SectionHeading node) {
		if (!lastWasSectionHeading && !buf.substring(buf.length()-2).equals("\n\n"))
			newLine();
		
		lastWasSectionHeading=true;
		
		metaText("<h1>");
		text(node.getSectionHeader().replaceAll("[\n\r]", ""));
		metaText("</h1>");
	}

	protected void visitAfter(SectionHeading node) {
	}

	protected void visitAfter(EtsiBnf node) {
		weaveComments();
	}
}
