package de.ugoe.cs.swe.bnftools.ebnf.javaextensions;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;

public class SimpleBNFHelper {

	private static HashMap<String, Rule> ruleMap = new HashMap<String, Rule>();
//	private static HashMap<String, Integer> indexMap = new HashMap<String, Integer>();
	
	public final static void dump(String aString) {
		System.out.println(aString);
	}

	// ----------------------------------------------------------------------

	public final static String definitionListToString(DefinitionList defList) {
		return "hello";
	}
	
	// ----------------------------------------------------------------------
	
	public final static String listToString(List<EObject> defList) {
		if (defList == null)
			return "***Java:listToString(List<EObject>defList: defList is null!!!***";
		if (defList.size() == 0)
			return "***Java:listToString(List<EObject>defList: defList is empty!!!***";
		
		try {
			StringBuffer strBuf = new StringBuffer();
			for (int i = 0; i < defList.size(); i++) {
				strBuf.append(ModelUtils.serialize(defList.get(i)));
			}

//			return strBuf.toString().replaceAll("[ \t\n\r]", "");
			return strBuf.toString();
		} catch (IOException e) {
			return "***listToString(List<EObject>defList: IOException***";
		}
	}

	// ----------------------------------------------------------------------
	
	public final static String eobjectToString(EObject o) {
		try {
			StringBuffer strBuf = new StringBuffer();
			strBuf.append(ModelUtils.serialize(o));

//			return strBuf.toString().replaceAll("[ \t\n\r]", "");
			return strBuf.toString();
		} catch (IOException e) {
			return "***listToString(List<EObject>defList: IOException***";
		}
	}

	
	// ----------------------------------------------------------------------
	
	public final static String listToHash(List<EObject> defList) {
		if (defList == null)
			return "***Java:listToHash(List<EObject>defList: defList is null!!!***";
		if (defList.size() == 0)
			return "***Java:listToHash(List<EObject>defList: defList is empty!!!***";
		
		try {
			StringBuffer strBuf = new StringBuffer();
			for (int i = 0; i < defList.size(); i++) {
				strBuf.append(ModelUtils.serialize(defList.get(i)));
			}

			String result = SHA1(strBuf.toString());
			return SHA1(result);
		} catch (IOException e) {
			return "***Java:listToHash(List<EObject>defList: IOException***";
		} catch (NoSuchAlgorithmException e) {
			return "***Java:listToHash(List<EObject>defList: NoSuchAlgorithmException***";
		}
	}

	// ----------------------------------------------------------------------
	
	public final static void storeRule(String key, Rule rule) {
		ruleMap.put(key, rule);
	}

	// ----------------------------------------------------------------------
	
	public final static Boolean existsRule(String key) {
		if (ruleMap.get(key) != null)
			return true;
		else
			return false;
	}
	
	// ----------------------------------------------------------------------

	public final static Rule getRule(String key) {
		return ruleMap.get(key);
	}

	// ----------------------------------------------------------------------

	public final static EObject copyEObject(EObject o) {
		return EcoreUtil.copy(o);
	}

	// ----------------------------------------------------------------------

	public final static List<EObject> copyEObjectList(List<EObject> o) {
		return (List<EObject>) EcoreUtil.copyAll(o);
	}

	// ----------------------------------------------------------------------

	public final static List<DefinitionList> copyDefinitionList(List<DefinitionList> o) {
		return (List<DefinitionList>) EcoreUtil.copyAll(o);
	}
	
	// ----------------------------------------------------------------------

	private static String convertToHex(byte[] data) {
		StringBuffer buf = new StringBuffer();
		for (int i = 0; i < data.length; i++) {
			int halfbyte = (data[i] >>> 4) & 0x0F;
			int two_halfs = 0;
			do {
				if ((0 <= halfbyte) && (halfbyte <= 9))
					buf.append((char) ('0' + halfbyte));
				else
					buf.append((char) ('a' + (halfbyte - 10)));
				halfbyte = data[i] & 0x0F;
			} while (two_halfs++ < 1);
		}
		return buf.toString();
	}

	// ----------------------------------------------------------------------

	private static String SHA1(String text) throws NoSuchAlgorithmException,
			UnsupportedEncodingException {
		MessageDigest md;
		md = MessageDigest.getInstance("SHA-1");
		byte[] sha1hash = new byte[40];
		md.update(text.getBytes("iso-8859-1"), 0, text.length());
		sha1hash = md.digest();
		return convertToHex(sha1hash);
	}

}
