package de.ugoe.cs.swe.bnftools.ui.quickfix.modifications;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;

import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ui.quickfix.processors.InlineRulesProcessor;
import de.ugoe.cs.swe.bnftools.utils.DeclarationReferencesPair;
import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;
import de.ugoe.cs.swe.bnftools.utils.Utils;

public class InlineRuleModification implements ISemanticModification {
	
	IResourceDescriptions resourceDescriptions;
	
	// ----------------------------------------------------------------------------------------------------

	public InlineRuleModification(IResourceDescriptions resourceDescriptions) {
		this.resourceDescriptions = resourceDescriptions;
	}

	// ----------------------------------------------------------------------------------------------------
	
	public void apply(EObject element, IModificationContext context)
			throws Exception {
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage().getActiveEditor();

//TODO: better error handling		
		if (!(editor.getDocument() instanceof XtextDocument)) {
			return;
		}

		if (!(element instanceof Rule))
			return;
		
		Rule rule = (Rule) element;
		
		XtextDocument doc = (XtextDocument) editor.getDocument();
		EObject root = doc.readOnly(new RootEObjectFinder());
		NodeAdapter rootNode = NodeUtil.getNodeAdapter(root);
		
		List<DeclarationReferencesPair> nodePairs = new ArrayList<DeclarationReferencesPair>();
		
		List<CompositeNode> references = Utils.findReferences(rule,
				resourceDescriptions, editor);
		
		nodePairs.add(new DeclarationReferencesPair(NodeUtil.getNodeAdapter(rule).getParserNode(), references));
		
		InlineRulesProcessor processor = new InlineRulesProcessor(editor, rootNode.getParserNode(), doc, nodePairs, true);

		NullProgressMonitor pm = new NullProgressMonitor();

		Change change;
		try {
			change = processor.createChange(pm);
			change.initializeValidationData(pm);
			change.setEnabled(true);
			PerformChangeOperation operation = new PerformChangeOperation(
					change);
			operation.setUndoManager(RefactoringCore.getUndoManager(),
					processor.getProcessorName());
			operation.run(pm);
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
