package de.ugoe.cs.swe.bnftools.ui.quickfix.processors;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

import de.ugoe.cs.swe.bnftools.utils.Utils;

public class RemoveUnusedRulesProcessor extends RefactoringProcessor {
	IFile file;
	private List<CompositeNode> unusedRuleNodes;
	private IXtextDocument document;
	
	// ----------------------------------------------------------------------------------------------------

	public RemoveUnusedRulesProcessor(XtextEditor editor, IXtextDocument doc, List<CompositeNode> unusedRuleNodes) {
		file = (IFile) editor.getEditorInput().getAdapter(IFile.class);
		this.unusedRuleNodes = unusedRuleNodes;
		this.document = doc;
	}
	
	// ----------------------------------------------------------------------------------------------------

	@Override
	public Object[] getElements() {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getIdentifier() {
		return "Remove Unused Rules Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getProcessorName() {
		return "Remove Unused Rules Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public boolean isApplicable() throws CoreException {
		return (unusedRuleNodes != null) && (unusedRuleNodes.size() > 0);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkInitialConditions(IProgressMonitor pm)
			throws CoreException, OperationCanceledException {
		
		RefactoringStatus status = new RefactoringStatus();

		if (unusedRuleNodes == null) {
			status.addFatalError("No unused rule node!");
		} else if (unusedRuleNodes.size() == 0) {
			status.addFatalError("No unused rule node!");
		} 
		return status;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkFinalConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws CoreException,
			OperationCanceledException {
		
		return checkInitialConditions(pm);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {
		/*
		 * Create a change, initialise the IProgressMonitor with 2 task:
		 * 1. renaming the reference with the rule's right side
		 * 2. renaming the whole rule with an empty string
		 */
		CompositeChange compositeChange = new CompositeChange("Remove Unused Rules");
		pm.beginTask("Remove Unused Rules", unusedRuleNodes.size());
		
		//initialising the edit
		MultiTextEdit multiEdit = new MultiTextEdit();
		TextFileChange fileChange = new TextFileChange("Remove Unused Rule", file);
		fileChange.setEdit(multiEdit);
		fileChange.setTextType("bnf");
		compositeChange.add(fileChange);
		
		for (int i=0; i < unusedRuleNodes.size(); i++) {
			CompositeNode declarationRule = unusedRuleNodes.get(i);

			// delete the declaration
			int offset = declarationRule.getOffset();
			int amount = Utils.stepBackNewlines(document, offset);
			
			DeleteEdit deleteEdit = new DeleteEdit(offset-amount, declarationRule.getLength()+amount);
			multiEdit.addChild(deleteEdit);
			TextEditGroup editGroup = new TextEditGroup("declaration removal", deleteEdit);
			fileChange.addTextEditGroup(editGroup);
			pm.worked(1);
		}
		
		return compositeChange;
		
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringParticipant[] loadParticipants(RefactoringStatus status,
			SharableParticipants sharedParticipants) throws CoreException {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	
}