package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;

public class OptionFigure extends SyntaxDiagramFigure {

	private BorderLayout layout;

	public OptionFigure(SyntaxDiagramFigure optionFigure) {
		super();

		layout = new BorderLayout();
		
		setLayoutManager(layout);
		addFigure(optionFigure);
		setBorder(new LineMarginBorder(10,40,10,40,0));
	}
	
	private void addFigure(SyntaxDiagramFigure f) {
		SyntaxDiagramFigure upperContainer = new SyntaxDiagramFigure();
		//upperContainer.setBorder(new LineBorder());
		upperContainer.setPreferredSize(new Dimension(10,40));
		ToolbarLayout loopLayout = new ToolbarLayout();
		loopLayout.setStretchMinorAxis(false);
		loopLayout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
		loopLayout.setVertical(true);
		upperContainer.setLayoutManager(loopLayout);
		//upperContainer.setForegroundColor(ColorConstants.blue);
		upperContainer.setVisible(true);
		add(upperContainer, BorderLayout.TOP);
		setLeftAnchor(new SideAnchor(this, upperContainer.getLeftAnchor(), SideAnchor.LEFT_SIDE));
		setRightAnchor(new SideAnchor(this, upperContainer.getRightAnchor(), SideAnchor.RIGHT_SIDE));
		layout.setConstraint(upperContainer, BorderLayout.TOP);

		SyntaxDiagramFigure dummy = new SyntaxDiagramFigure();
		//dummy.setBorder(new LineBorder());
		dummy.setPreferredSize(-1, upperContainer.getPreferredSize().height);
		dummy.setVisible(true);
		upperContainer.add(dummy);

		PathFigure upperGoThroughPath1 = new PathFigure();
		upperGoThroughPath1.setSourceAnchor(upperContainer.getLeftAnchor());
		upperGoThroughPath1.setTargetAnchor(dummy.getLeftAnchor());
		upperContainer.add(upperGoThroughPath1);

		PathFigure upperGoThroughPath2 = new PathFigure();
		upperGoThroughPath2.setSourceAnchor(dummy.getRightAnchor());
		upperGoThroughPath2.setTargetAnchor(upperContainer.getRightAnchor());
		upperContainer.add(upperGoThroughPath2);

		PathFigure upperGoThroughPath3 = new PathFigure();
		upperGoThroughPath3.setTargetDecoration(null);
		upperGoThroughPath3.setSourceAnchor(dummy.getRightAnchor());
		upperGoThroughPath3.setTargetAnchor(this.getRightAnchor());
		add(upperGoThroughPath3);

		
		SyntaxDiagramFigure centerContainer = new SyntaxDiagramFigure();
		centerContainer.setLayoutManager(new ToolbarLayout());
		centerContainer.setVisible(true);
		add(centerContainer, BorderLayout.CENTER);
		layout.setConstraint(centerContainer, BorderLayout.CENTER);

//		PathFigure innerGoThroughPath = new PathFigure();
//		innerGoThroughPath.setSourceAnchor(upperContainer.getLeftAnchor());
//		innerGoThroughPath.setTargetAnchor(upperContainer.getRightAnchor());
//		upperContainer.add(innerGoThroughPath);

		PathFigure innerGoThroughPath2 = new PathFigure();
//		innerGoThroughPath2.setTargetDecoration(null);
		innerGoThroughPath2.setSourceAnchor(this.getLeftAnchor());
		innerGoThroughPath2.setTargetAnchor(upperContainer.getLeftAnchor());
		add(innerGoThroughPath2);

		centerContainer.add(f);
		
		PathFigure leftPath = new PathFigure();
		leftPath.setTargetDecoration(null);
		leftPath.setSourceAnchor(this.getLeftAnchor());
		leftPath.setTargetAnchor(f.getLeftAnchor());
		add(leftPath);

		PathFigure rightPath = new PathFigure();
//		rightPath.setTargetDecoration(null);
		rightPath.setSourceAnchor(f.getRightAnchor());
		rightPath.setTargetAnchor(this.getRightAnchor());
		add(rightPath);

	}
	
}
