package resource.tools.xtools;


import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature.Setting;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.slf4j.LoggerFactory;

import de.ugoe.cs.swe.bnftools.EbnfStandaloneSetup;
import de.ugoe.cs.swe.bnftools.ebnf.EbnfPackage;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.impl.EbnfPackageImpl;
import resource.tools.xtools.ResourceTool;

public class EbnfResourceTool extends ResourceTool {
	
	public EbnfResourceTool(){
		super();
		log = LoggerFactory.getLogger(EbnfResourceTool.class);
		EbnfPackageImpl.init();
		initializeValidator();
		injector = new EbnfStandaloneSetup().createInjectorAndDoEMFRegistration();
	}
	
	@Override
	protected void initializeValidator(){
		super.initializeValidator();
		EObjectValidator validator = new EObjectValidator();
		EValidator.Registry.INSTANCE.put(EbnfPackage.eINSTANCE, validator);
	}

	public void processFile(File xtextFile) {

		//TODO: extract as configuration
		String extension = "bnf";
		String workspace = xtextFile.getParentFile().getAbsolutePath();
		String xTextLocation = xtextFile.getAbsolutePath();
		String outputPath = xtextFile.getAbsolutePath()+".ebnf";
		String outputPathValidated = xtextFile.getAbsolutePath()+".ebnf";
		
		Resource resource = loadResourceFromXtext(workspace,xTextLocation,true);
		findReferences(resource);
		storeResourceContents(resource.getContents(), outputPath, extension);
		Resource fromXMI = loadResourceFromXMI(outputPath, extension);
//	    validateResource(fromXMI);
		storeResourceContents(fromXMI.getContents(), outputPathValidated, extension);
	}

	private void findReferences(Resource resource) {
		//custom reference finding, specific for BNF rule references 
		//could be generalized for any references at the Ecore level
		//but maybe it is fully sufficient
		EtsiBnf bnf = (EtsiBnf) resource.getContents().get(0);

		//first approach
		System.out.println("***** first approach (top down)");
		List<Rule> rules = EcoreUtil2.getAllContentsOfType(bnf, Rule.class);
		for (Rule r : rules) {
			System.out.println("Processing rule "+r.getName());
			for (RuleReference ref : EcoreUtil2.getAllContentsOfType(r, RuleReference.class)) {
				EcoreUtil2.getContainerOfType(ref, Rule.class);
				System.out.println("  " + r.getName() + " references " + ref.getRuleref().getName());
				System.out.println("    -> reference index shall contain \"" + ref.getRuleref().getName() + " referenced in " + r.getName() + "\"");
				
			}
		}
		
		//second approach
		System.out.println("***** second approach (bottom up)");
		for (RuleReference ref : EcoreUtil2.getAllContentsOfType(bnf, RuleReference.class)) {
			Rule r = EcoreUtil2.getContainerOfType(ref, Rule.class);
			System.out.println("" + r.getName() + " references " + ref.getRuleref().getName());
			System.out.println("  -> reference index shall contain \"" + ref.getRuleref().getName() + " referenced in " + r.getName() + "\"");
			
		}
		
		//third approach
		System.out.println("***** third approach (cross referencing)");
		for (Rule r : rules) {
			System.out.println("Processing rule "+r.getName());
			for (Setting s : EcoreUtil.UsageCrossReferencer.find(r, bnf)) {
				RuleReference ref = (RuleReference) s.getEObject();
				Rule referencingRule = EcoreUtil2.getContainerOfType(ref, Rule.class);
				System.out.println("" + referencingRule.getName() + " references " + r.getName());
				System.out.println("  -> reference index shall contain \"" + r.getName() + " referenced in " + referencingRule.getName() + "\"");
			}
		}
		

	}

	public void process(String workspace) {

		//TODO: extract as configuration
		String extension = "tplan2x";
		String xTextLocation = workspace+"/model."+extension;
		String outputPath = workspace+"/model.tplan2";
		String outputPathValidated = workspace+"/model.tplan2";
		
		Resource resource = loadResourceFromXtext(workspace,xTextLocation,true);
		storeResourceContents(resource.getContents(), outputPath, extension);
		Resource fromXMI = loadResourceFromXMI(outputPath, extension);
//	    validateResource(fromXMI);
		storeResourceContents(fromXMI.getContents(), outputPathValidated, extension);
	}
	
}
