/*
* generated by Xtext
*/
package de.ugoe.cs.swe.bnftools.ui.quickfix

import org.eclipse.xtext.ui.editor.quickfix.Fix
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor
import org.eclipse.xtext.validation.Issue
import de.ugoe.cs.swe.bnftools.validation.EbnfValidator
import org.eclipse.xtext.ui.editor.model.IXtextDocument
import org.eclipse.emf.ecore.EObject
import de.ugoe.cs.swe.bnftools.ebnf.Rule
import de.ugoe.cs.swe.bnftools.ebnf.EbnfFactory
import org.eclipse.xtext.nodemodel.util.NodeModelUtils
import org.eclipse.xtext.nodemodel.INode
import de.ugoe.cs.swe.bnftools.validation.EbnfAnalysisUtils
import java.util.List
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference
import org.eclipse.xtext.nodemodel.ICompositeNode
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf
import java.util.ArrayList
import org.eclipse.xtext.EcoreUtil2
import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry
import org.eclipse.emf.ecore.util.EcoreUtil
import org.eclipse.emf.common.util.EList
import org.eclipse.xtext.resource.IResourceDescriptions
import com.google.inject.Inject
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition
import de.ugoe.cs.swe.bnftools.ebnf.util.EbnfAdapterFactory

/**
 * Custom quickfixes.
 *
 * see http://www.eclipse.org/Xtext/documentation.html#quickfixes
 */
class EbnfQuickfixProvider extends org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider {

	@Inject
	IResourceDescriptions resourceDescriptions;

	//*****************************************************************************************
	//works but only in one file
		@Fix(EbnfValidator.ruleReferencedOneDescription)
		def void fixInlineRuleReferencedOnce(Issue issue, IssueResolutionAcceptor acceptor) {
			acceptor.accept(
				issue,
				"Inline the rule",
				"Delete the rule and replace its single reference by the rule's right side",
				"upcase.png"
			) [ element, context |
				var Rule rule = element as Rule;
				var IXtextDocument xtextDocument = context.getXtextDocument();
				var ICompositeNode node = NodeModelUtils.findActualNodeFor(rule);
				var String nodeText = node.text;
				var int textLength = nodeText.length - 2;
				var int offset = node.textRegion.offset;
				//rename references
				var ICompositeNode dList = NodeModelUtils.findActualNodeFor(rule.definitionList);
				var String refText = "(" + dList.text + ")";
				var int refLength = rule.name.length;
				var List<RuleReference> references = EbnfAnalysisUtils.findReferences(rule);
				//*********************************
				//is the reference in the rule itself?
				var boolean foundRule = false;
				var EObject r = references.get(0) as EObject;
				var Rule containingRule = null;
				while (!foundRule) {
					r = r.eContainer;
					if (r instanceof Rule) {
						containingRule = r as Rule;
						foundRule = true;
					}
				}
				if (!rule.equals(containingRule)) {
	
									for (ruleRef : references) {
										var ICompositeNode refNode = NodeModelUtils.findActualNodeFor(ruleRef);
										var int refOffset = refNode.textRegion.offset;
					
										xtextDocument.replace(refOffset, refLength, refText);
										if (refOffset < offset) {
											offset += refText.length - refLength;
										}
									}
									
				// delete rule
				}
				
				xtextDocument.replace(offset, textLength, "");
			]
	
		}
	
//	// this is not working by unknown reasons 
//	@Fix(EbnfValidator.ruleReferencedOneDescription)
//	def void fixInlineRuleReferencedOnce(Issue issue, IssueResolutionAcceptor acceptor) {
//		acceptor.accept(
//			issue,
//			"Inline the rule",
//			"Delete the rule and replace its single reference by the rule's right side",
//			"upcase.png"
//		) [ element, context |
//			var Rule rule = element as Rule;
//			var DefinitionList dlist = rule.definitionList;
//			var List<Rule> rules=EbnfAnalysisUtils.getAllRules(rule.eContainer().eContainer() as EtsiBnf);
//			var SingleDefinition sDef = rules.get(1).definitionList.singleDefinition.get(1);
//			dlist.singleDefinition.add(sDef);
//			rule.name="bla";
//		]
//
//	}

	//*****************************************************************************************
	//		@Fix(EbnfValidator.passthroughRuleDescription)
	//	def void fixRemovePassthroughRule(Issue issue, IssueResolutionAcceptor acceptor) {
	//		acceptor.accept(
	//			issue,
	//			"Remove passthrough rule",
	//			"Delete the passthrough rule and replace its references with its right side",
	//			"upcase.png",
	//			[ element, context |
	//				var Rule rule = element as Rule;
	//				var IXtextDocument xtextDocument = context.getXtextDocument();
	//				var ICompositeNode node = NodeModelUtils.findActualNodeFor(rule);
	//				var String nodeText = node.text;
	//				var int textLength = nodeText.length - 2;
	//				var int offset = node.textRegion.offset;
	//				var ICompositeNode dList = NodeModelUtils.findActualNodeFor(rule.definitionList);
	//				var String refText = "(" + dList.text + ")";
	//				var int refLength = rule.name.length;
	//				var List<RuleReference> references = EbnfAnalysisUtils.findReferences(rule);
	//				//sort references by offset
	//				var int i = 0;
	//				var List<RuleReference> referenceHleper = new ArrayList<RuleReference>();
	//				while(i<references.length){
	//					
	//					i++;
	//				}
	//				for (ruleRef : references) {
	//					var ICompositeNode refNode = NodeModelUtils.findActualNodeFor(ruleRef);
	//					var int refOffset = refNode.textRegion.offset;
	//
	//					xtextDocument.replace(refOffset, refLength, refText);
	//					if (refOffset < offset) {
	//						offset += refText.length - refLength;
	//					}
	//				}
	//			]
	//		);
	//	}
	
	//*****************************************************************************************
	//works
	@Fix(EbnfValidator.unusedRuleDescription)
	def void fixUnusedRule(Issue issue, IssueResolutionAcceptor acceptor) {

		acceptor.accept(issue, "Remove unused rule", "Delete the unused rule", "upcase.png",
			[ element, context |
				var Rule rule = element as Rule;
				var IXtextDocument xtextDocument = context.getXtextDocument();
				var ICompositeNode node = NodeModelUtils.findActualNodeFor(rule);
				var int offset = node.textRegion.offset;
				var String nodeText = node.text;
				var int textLength = nodeText.length - 2;
				xtextDocument.replace(offset, textLength, "");
			])
	}
}
