package de.ugoe.cs.swe.bnftools.ebnf.standalone;

import java.io.File;
import java.io.IOException;

import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextSourceViewer;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorFactory;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import com.google.inject.Inject;
import com.google.inject.Injector;

import de.ugoe.cs.swe.bnftools.EbnfStandaloneSetup;
import de.ugoe.cs.swe.bnftools.ui.internal.EbnfActivator;

@SuppressWarnings("restriction")
public class View extends ViewPart {
	private static final String FILE = "/Users/philip-iii/Dev/workspaces/bnf-v2/de.ugoe.cs.swe.bnftools.ebnf.standalone/somefile.bnf";

	public static final String ID = "de.ugoe.cs.swe.bnftools.ebnf.standalone.view";

	//NEW
	@Inject EBNFEditedResourceProvider editedResourceProvider;
	@Inject EmbeddedEditorFactory factory;

	
	private TableViewer viewer;
	private EmbeddedEditor handle;
	private SashForm sashForm;
	private EmbeddedEditorModelAccess partialEditor;
	private XtextSourceViewer viewer2;


	/**
	 * The content provider class is responsible for providing objects to the
	 * view. It can wrap existing objects in adapters or simply return objects
	 * as-is. These objects may be sensitive to the current input of the view,
	 * or ignore it and always show the same content (like Task List, for
	 * example).
	 */
	class ViewContentProvider implements IStructuredContentProvider {
		public void inputChanged(Viewer v, Object oldInput, Object newInput) {
		}

		public void dispose() {
		}

		public Object[] getElements(Object parent) {
			if (parent instanceof Object[]) {
				return (Object[]) parent;
			}
	        return new Object[0];
		}
	}

	//NEW
	private void createEditor() {
		IEditedResourceProvider resourceProvider = new IEditedResourceProvider() {

	        @Override
	        public XtextResource createResource() {
	            try {
	                EbnfStandaloneSetup.doSetup();
	                ResourceSet resourceSet = new ResourceSetImpl();
	                Resource resource = resourceSet.createResource(URI.createURI(FILE));
	                return (XtextResource) resource;
	            } catch (Exception e) {
	                return null;
	            }
	        }
	    };

	    //or change to current activator...
	    EbnfActivator activator = EbnfActivator.getInstance();
	    Injector injector = activator
	            .getInjector(EbnfActivator.DE_UGOE_CS_SWE_BNFTOOLS_EBNF);
	    EmbeddedEditorFactory factory = injector.getInstance(EmbeddedEditorFactory.class);
	    handle = factory.newEditor(resourceProvider).withParent(
	            sashForm);
	    
	    
	    // keep the partialEditor as instance var to read / write the edited text
	    partialEditor = handle.createPartialEditor(true);
	    viewer2 = handle.getViewer();
		final File f = new File(FILE);
    	try {
			String string = FileUtils.readFileToString(f);
			viewer2.getDocument().set(string);
		} catch (IOException e1) {
			e1.printStackTrace();
		}
	    viewer2.addTextInputListener(new ITextInputListener() {
			
			@Override
			public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
				System.out.println("-->save");
				XtextDocument d = (XtextDocument) oldInput;
				System.out.println(oldInput.get());
				System.out.println(f.getAbsolutePath());
				try {
					FileUtils.writeStringToFile(f, oldInput.get());
				} catch (IOException e) {
					e.printStackTrace();
				}
			}
			
			@Override
			public void inputDocumentAboutToBeChanged(IDocument oldInput,
					IDocument newInput) {
			}
		});
	}

	
	class ViewLabelProvider extends LabelProvider implements
			ITableLabelProvider {
		public String getColumnText(Object obj, int index) {
			return getText(obj);
		}

		public Image getColumnImage(Object obj, int index) {
			return getImage(obj);
		}

		public Image getImage(Object obj) {
			return PlatformUI.getWorkbench().getSharedImages().getImage(
					ISharedImages.IMG_OBJ_ELEMENT);
		}
	}

	/**
	 * This is a callback that will allow us to create the viewer and initialize
	 * it.
	 */
	public void createPartControl(Composite parent) {
		sashForm = new SashForm(parent, SWT.HORIZONTAL);
		sashForm.setLayout(new FillLayout());
		createEditor();

		viewer = new TableViewer(sashForm, SWT.MULTI | SWT.H_SCROLL
				| SWT.V_SCROLL);
		viewer.setContentProvider(new ViewContentProvider());
		viewer.setLabelProvider(new ViewLabelProvider());
		// Provide the input to the ContentProvider
		viewer.setInput(new String[] {"One", "Two", "Three"});
	}

	/**
	 * Passing the focus request to the viewer's control.
	 */
	public void setFocus() {
		viewer.getControl().setFocus();
	}
}