package de.ugoe.cs.swe.bnftools.visitor;

import java.util.Collections;

import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Import;

import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.MergeRule;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;

public abstract class EbnfVisitor {
	protected EObject rootNode = null;

	public EbnfVisitor() {
	}

	public EbnfVisitor(EObject rootNode) {
		this.rootNode = rootNode;
	}

	public void accept() {
		if (rootNode != null)
			accept(rootNode);
	}

	public void accept(EObject node) {
		TreeIterator<Object> it = EcoreUtil.getAllContents(Collections
				.singleton(node));

		while (it.hasNext()) {
			EObject currentNode = (EObject) it.next();
			dispatcher(currentNode);
		}
	}

	protected void dispatcher(EObject node) {
		// ugly, but no time to find a prettier solution
		if (node instanceof EtsiBnf) {
			visit((EtsiBnf) node);
		} else if (node instanceof Atom) {
			visit((Atom) node);
		} else if (node instanceof DefinitionList) {
			visit((DefinitionList) node);
		} else if (node instanceof ExtRule) {
			visit((ExtRule) node);
		} else if (node instanceof GlobalCombinator) {
			visit((GlobalCombinator) node);
		} else if (node instanceof GroupedSequence) {
			visit((GroupedSequence) node);
		} else if (node instanceof HookCombinator) {
			visit((HookCombinator) node);
		} else if (node instanceof Import) {
			visit((Import) node);
		} else if (node instanceof MergeRule) {
			visit((MergeRule) node);
		} else if (node instanceof OptionalSequence) {
			visit((OptionalSequence) node);
		} else if (node instanceof RepeatedSequence) {
			visit((RepeatedSequence) node);
		} else if (node instanceof Rule) {
			visit((Rule) node);
		} else if (node instanceof RuleCombinator) {
			visit((RuleCombinator) node);
		} else if (node instanceof RuleReference) {
			visit((RuleReference) node);
		} else if (node instanceof SectionHeading) {
			visit((SectionHeading) node);
		} else if (node instanceof SingleDefinition) {
			visit((SingleDefinition) node);
		} else if (node instanceof StringRule) {
			visit((StringRule) node);
		} else if (node instanceof Term) {
			visit((Term) node);
		}
	}
	
	protected void visit(EtsiBnf node) {
	}

	protected void visit(Atom node) {
	}

	protected void visit(DefinitionList node) {
	}

	protected void visit(ExtRule node) {
	}

	protected void visit(GlobalCombinator node) {
	}

	protected void visit(GroupedSequence node) {
	}

	protected void visit(HookCombinator node) {
	}

	protected void visit(Import node) {
	}

	protected void visit(MergeRule node) {
	}

	protected void visit(OptionalSequence node) {
	}

	protected void visit(RepeatedSequence node) {
	}

	protected void visit(Rule node) {
	}

	protected void visit(RuleCombinator node) {
	}

	protected void visit(RuleReference node) {
	}

	protected void visit(SectionHeading node) {
	}

	protected void visit(SingleDefinition node) {
	}

	protected void visit(StringRule node) {
	}

	protected void visit(Term node) {
	}

}
