package de.ugoe.cs.swe.bnftools.ui.formatter;

import org.eclipse.emf.ecore.EObject;

import com.sun.xml.internal.bind.v2.schemagen.xmlschema.Import;

import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.MergeRule;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;
import de.ugoe.cs.swe.bnftools.visitor.EbnfVisitor;

public class EbnfFormatterVisitor extends EbnfVisitor {
	private StringBuffer buf;
	private FormatterConfig config;

	public EbnfFormatterVisitor(EObject rootNode, FormatterConfig config) {
		super(rootNode);
		this.config = config;
		buf = new StringBuffer();
	}

	public EbnfFormatterVisitor(FormatterConfig config) {
		this.config = config;
		buf = new StringBuffer();
	}

	public StringBuffer getBuf() {
		return buf;
	}

	// -----------------------------------------------------------------------------

	protected void visit(EtsiBnf node) {
		buf.append("grammar " + node.getName());
		if (node.getType() != null)
			buf.append(node.getType());
		buf.append(";");
	}

	protected void visit(Atom node) {
	}

	protected void visit(DefinitionList node) {
	}

	protected void visit(ExtRule node) {
	}

	protected void visit(GlobalCombinator node) {
	}

	protected void visit(GroupedSequence node) {
	}

	protected void visit(HookCombinator node) {
	}

	protected void visit(Import node) {
	}

	protected void visit(MergeRule node) {
	}

	protected void visit(OptionalSequence node) {
	}

	protected void visit(RepeatedSequence node) {
	}

	protected void visit(Rule node) {
	}

	protected void visit(RuleCombinator node) {
	}

	protected void visit(RuleReference node) {
	}

	protected void visit(SectionHeading node) {
	}

	protected void visit(SingleDefinition node) {
	}

	protected void visit(StringRule node) {
	}

	protected void visit(Term node) {
	}

}
