package de.ugoe.cs.swe.bnftools.visitor;

import java.util.Stack;

import org.eclipse.emf.ecore.EObject;

import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.Import;
import de.ugoe.cs.swe.bnftools.ebnf.MergeRule;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;

public abstract class EbnfVisitor {
	
	protected EObject rootNode = null;
	protected Stack<Boolean> lastElementStack = new Stack<Boolean>();
	
	public EbnfVisitor() {
	}

	public EbnfVisitor(EObject rootNode) {
		this.rootNode = rootNode;
	}

	public void accept() {
		if (rootNode != null)
			accept(rootNode);
	}

	public void accept(EObject node) {
		dispatcherBefore(node);
		acceptInner(node);
		dispatcherAfter(node);
	}

	private void acceptInner(EObject node) {
		Boolean lastElement = false;
		if (node.eContents().size() == 0)
			lastElement = true;
		lastElementStack.push(lastElement);		
		for (int i=0; i < node.eContents().size(); i++) {
			EObject currentNode = (EObject) node.eContents().get(i);
			if (i == node.eContents().size()-1) {
				lastElement = true;
				lastElementStack.pop();
				lastElementStack.push(lastElement);
			}
			dispatcherBefore(currentNode);
			acceptInner(currentNode);
			dispatcherAfter(currentNode);
		}
		lastElementStack.pop();
	}
	
	protected boolean isLastElement() {
		return lastElementStack.peek();
	}
	
	protected void dispatcherBefore(EObject node) {
		// ugly, but no time to find a prettier solution
		if (node instanceof EtsiBnf) {
			visitBefore((EtsiBnf) node);
		} else if (node instanceof Atom) {
			visitBefore((Atom) node);
		} else if (node instanceof DefinitionList) {
			visitBefore((DefinitionList) node);
		} else if (node instanceof ExtRule) {
			visitBefore((ExtRule) node);
		} else if (node instanceof GlobalCombinator) {
			visitBefore((GlobalCombinator) node);
		} else if (node instanceof GroupedSequence) {
			visitBefore((GroupedSequence) node);
		} else if (node instanceof HookCombinator) {
			visitBefore((HookCombinator) node);
		} else if (node instanceof Import) {
			visitBefore((Import) node);
		} else if (node instanceof MergeRule) {
			visitBefore((MergeRule) node);
		} else if (node instanceof OptionalSequence) {
			visitBefore((OptionalSequence) node);
		} else if (node instanceof RepeatedSequence) {
			visitBefore((RepeatedSequence) node);
		} else if (node instanceof Rule) {
			visitBefore((Rule) node);
		} else if (node instanceof RuleCombinator) {
			visitBefore((RuleCombinator) node);
		} else if (node instanceof RuleReference) {
			visitBefore((RuleReference) node);
		} else if (node instanceof SectionHeading) {
			visitBefore((SectionHeading) node);
		} else if (node instanceof SingleDefinition) {
			visitBefore((SingleDefinition) node);
		} else if (node instanceof StringRule) {
			visitBefore((StringRule) node);
		} else if (node instanceof Term) {
			visitBefore((Term) node);
		}
	}
	
	protected void dispatcherAfter(EObject node) {
		// ugly, but no time to find a prettier solution
		if (node instanceof EtsiBnf) {
			visitAfter((EtsiBnf) node);
		} else if (node instanceof Atom) {
			visitAfter((Atom) node);
		} else if (node instanceof DefinitionList) {
			visitAfter((DefinitionList) node);
		} else if (node instanceof ExtRule) {
			visitAfter((ExtRule) node);
		} else if (node instanceof GlobalCombinator) {
			visitAfter((GlobalCombinator) node);
		} else if (node instanceof GroupedSequence) {
			visitAfter((GroupedSequence) node);
		} else if (node instanceof HookCombinator) {
			visitAfter((HookCombinator) node);
		} else if (node instanceof Import) {
			visitAfter((Import) node);
		} else if (node instanceof MergeRule) {
			visitAfter((MergeRule) node);
		} else if (node instanceof OptionalSequence) {
			visitAfter((OptionalSequence) node);
		} else if (node instanceof RepeatedSequence) {
			visitAfter((RepeatedSequence) node);
		} else if (node instanceof Rule) {
			visitAfter((Rule) node);
		} else if (node instanceof RuleCombinator) {
			visitAfter((RuleCombinator) node);
		} else if (node instanceof RuleReference) {
			visitAfter((RuleReference) node);
		} else if (node instanceof SectionHeading) {
			visitAfter((SectionHeading) node);
		} else if (node instanceof SingleDefinition) {
			visitAfter((SingleDefinition) node);
		} else if (node instanceof StringRule) {
			visitAfter((StringRule) node);
		} else if (node instanceof Term) {
			visitAfter((Term) node);
		}
	}

	protected void visitBefore(EtsiBnf node) {
	}

	protected void visitAfter(EtsiBnf node) {
	}

	protected void visitBefore(Atom node) {
	}

	protected void visitAfter(Atom node) {
	}

	protected void visitBefore(Term node) {
	}

	protected void visitAfter(Term node) {
	}

	protected void visitBefore(DefinitionList node) {
	}

	protected void visitAfter(DefinitionList node) {
	}

	protected void visitBefore(ExtRule node) {
	}

	protected void visitAfter(ExtRule node) {
	}

	protected void visitBefore(GlobalCombinator node) {
	}

	protected void visitAfter(GlobalCombinator node) {
	}

	protected void visitBefore(GroupedSequence node) {
	}

	protected void visitAfter(GroupedSequence node) {
	}

	protected void visitBefore(HookCombinator node) {
	}

	protected void visitAfter(HookCombinator node) {
	}

	protected void visitBefore(Import node) {
	}

	protected void visitAfter(Import node) {
	}

	protected void visitBefore(MergeRule node) {
	}

	protected void visitAfter(MergeRule node) {
	}

	protected void visitBefore(OptionalSequence node) {
	}

	protected void visitAfter(OptionalSequence node) {
	}

	protected void visitBefore(RepeatedSequence node) {
	}

	protected void visitAfter(RepeatedSequence node) {
	}

	protected void visitBefore(Rule node) {
	}

	protected void visitAfter(Rule node) {
	}

	protected void visitBefore(RuleCombinator node) {
	}

	protected void visitAfter(RuleCombinator node) {
	}

	protected void visitBefore(RuleReference node) {
	}

	protected void visitAfter(RuleReference node) {
	}

	protected void visitBefore(SectionHeading node) {
	}

	protected void visitAfter(SectionHeading node) {
	}

	protected void visitBefore(SingleDefinition node) {
	}

	protected void visitAfter(SingleDefinition node) {
	}

	protected void visitBefore(StringRule node) {
	}

	protected void visitAfter(StringRule node) {
	}
	
}
