package de.ugoe.cs.swe.bnftools.ui.formatter;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;

public class HtmlFormatterHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();

		// TODO: better error handling
		if (!(editor.getDocument() instanceof XtextDocument)) {
			return null;
		}

		XtextDocument doc = (XtextDocument) editor.getDocument();
		IContainer parent = editor.getResource().getParent();

		EObject root = doc.readOnly(new RootEObjectFinder());
		NodeAdapter rootNode = NodeUtil.getNodeAdapter(root);

		FormatterConfig config = new FormatterConfig();
		EbnfHtmlFormatterVisitor visitor = new EbnfHtmlFormatterVisitor(
				rootNode.getParserNode().getElement(), config);

		visitor.accept();

		writeFile(visitor.getBuf().toString(), parent.getLocationURI().getPath() + "/" + editor.getResource().getName() + ".html");
		System.out.println(visitor.getBuf());
		
		return null;
	}

	private void writeFile(String str, String filename) {
		try {
			FileWriter fstream = new FileWriter(filename);
			BufferedWriter out = new BufferedWriter(fstream);
			out.write(str);
			out.close();
		} catch (Exception e) {// Catch exception if any
			System.err.println("Error: " + e.getMessage());
		}
	}

}
