package de.ugoe.cs.swe.bnftools.ui.syntaxcoloring;

import org.eclipse.xtext.ui.editor.syntaxcoloring.antlr.DefaultAntlrTokenToAttributeIdMapper;

public class EtsiBnfAntlrTokenToAttributeMapper extends
		DefaultAntlrTokenToAttributeIdMapper {
	String[] punctuation = new String[]{"::=", ";"};
	String[] operators = new String[]{"|", "+"};
	String[] parentheses = new String[]{"}", "{", "(", ")", "[", "]"};
	
	@Override
	protected String calculateId(String tokenName, int tokenType) {
		if (tokenName.contains("STRING")) {
			return EtsiBnfHighlightingConfiguration.STRING_ID;
		}
		if (tokenName.contains("COLON")) {
			return EtsiBnfHighlightingConfiguration.STRING_ID;
		}
		if (tokenName.contains("RULE_ID")) {
			return EtsiBnfHighlightingConfiguration.ID_ID;
		}
		if (tokenName.contains("SECTIONHEADER")) {
			return EtsiBnfHighlightingConfiguration.SECTIONHEADER_ID;
		}
		for (int i=0; i < punctuation.length; i++) {
			if (tokenName.contains(punctuation[i]))
				return EtsiBnfHighlightingConfiguration.PUNCTUATION_ID;
		}
		for (int i=0; i < operators.length; i++) {
			if (tokenName.contains(operators[i]))
				return EtsiBnfHighlightingConfiguration.OPERATOR_ID;
		}
		for (int i=0; i < parentheses.length; i++) {
			if (tokenName.contains(parentheses[i]))
				return EtsiBnfHighlightingConfiguration.PARENTHESES_ID;
		}
		if("RULE_ML_COMMENT".equals(tokenName) | "RULE_SL_COMMENT".equals(tokenName)) {
			return EtsiBnfHighlightingConfiguration.COMMENT_ID;
		}
		return EtsiBnfHighlightingConfiguration.DEFAULT_ID;
	}

}
