package de.ugoe.cs.swe.bnftools.ui.modelingtools;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;

import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;

public class SaveXMIHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		try {
			XtextEditor editor = (XtextEditor) HandlerUtil
					.getActiveEditor(event);
			
			EObject root = editor.getDocument().readOnly(new RootEObjectFinder());
			IProject project  = editor.getResource().getProject();
			IPath projectPath = project.getLocation();
			String name = editor.getResource().getName();
			
			saveModel(projectPath + "//" + name + ".xmi", root);
			project.refreshLocal(IResource.DEPTH_INFINITE, new NullProgressMonitor());
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}

	// --------------------------------------------------------------------------------

	public void saveModel(String filename, EObject project) {
		try {
			URI fileURI = URI.createFileURI(filename);
			Resource poResource = new XMLResourceFactoryImpl()
					.createResource(fileURI);
			poResource.getContents().add(project);
			poResource.save(null);
		} catch (Exception ex) {
			ex.printStackTrace();
		}
	}

}
