package de.ugoe.cs.swe.bnftools.ui.quickfix.processors;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

import de.ugoe.cs.swe.bnftools.analysis.EbnfAnalysisUtils;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.utils.DeclarationReferencesPair;
import de.ugoe.cs.swe.bnftools.utils.Utils;

public class ReplacePassthroughRuleProcessor extends RefactoringProcessor {
	IFile file;
	private List<DeclarationReferencesPair> nodePairs;
	private boolean isRemoveLine;
	private IXtextDocument document;
	
	// ----------------------------------------------------------------------------------------------------

	public ReplacePassthroughRuleProcessor(XtextEditor editor, IXtextDocument doc, List<DeclarationReferencesPair> nodePairs, boolean removal) {
		file = (IFile) editor.getEditorInput().getAdapter(IFile.class);
		this.nodePairs = nodePairs;
		this.isRemoveLine = removal;
		this.document = doc;
	}
	
	// ----------------------------------------------------------------------------------------------------

	@Override
	public Object[] getElements() {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getIdentifier() {
		return "Replace Passthrough Rule Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getProcessorName() {
		return "Replace Passthrough Rule Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public boolean isApplicable() throws CoreException {
		if ((nodePairs != null) && (nodePairs.size() > 0))
			return false;
		
		
		return true;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkInitialConditions(IProgressMonitor pm)
			throws CoreException, OperationCanceledException {
		
		RefactoringStatus status = new RefactoringStatus();

		if (nodePairs == null) {
			status.addFatalError("No passthrough rules to replace!");
		} else if (nodePairs.size() == 0) {
			status.addFatalError("No passthrough rules to replace!");
		}
		
		boolean isNodeWithReferences = false;
		for (int i=0; i < nodePairs.size(); i++) {
			if (nodePairs.get(i).getReferenceNodes().size() > 0) {
				isNodeWithReferences = true;
			}
		}
		
		if (!isNodeWithReferences)
			status.addFatalError("No passthrough rules to replace!");
		
		return status;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkFinalConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws CoreException,
			OperationCanceledException {
		
		return checkInitialConditions(pm);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {
		/*
		 * Create a change, initialise the IProgressMonitor with 2 task:
		 * 1. renaming the reference with the rule's right side
		 * 2. renaming the whole rule with an empty string
		 */
		CompositeChange compositeChange = new CompositeChange("Replace Passthrough Rule");
		pm.beginTask("Replace Passthrough Rule Refactoring", nodePairs.size());
		
		//initialising the edit
		MultiTextEdit multiEdit = new MultiTextEdit();
		TextFileChange fileChange = new TextFileChange("Replace Passthrough Rule", file);
		fileChange.setEdit(multiEdit);
		fileChange.setTextType("bnf");
		compositeChange.add(fileChange);
		
		for (int i=0; i < nodePairs.size(); i++) {
			CompositeNode declarationRule = nodePairs.get(i).getDeclarationNode();
			List<CompositeNode> ruleReferences = nodePairs.get(i).getReferenceNodes();
			// get the replacement name
			Rule rule = (Rule) declarationRule.getElement();
			RuleReference rightSideRule = EbnfAnalysisUtils.getPassthroughRuleReference(rule);
			String replaceRuleName = rightSideRule.getRuleref().getName();

			// replace references with passthrough rule name
			for (int j=0; j < ruleReferences.size(); j++) {
				CompositeNode ruleReference = ruleReferences.get(j);
				ReplaceEdit replaceEdit = new ReplaceEdit(ruleReference.getOffset(), ruleReference.getLength(), replaceRuleName);
				multiEdit.addChild(replaceEdit);
				TextEditGroup editGroup2 = new TextEditGroup("reference renaming", replaceEdit);
				fileChange.addTextEditGroup(editGroup2);
				pm.worked(1);
			}

			// remove old line
			if (isRemoveLine) {
				int amount = Utils.stepBackNewlines(document, declarationRule.getOffset());
				DeleteEdit deleteEdit = new DeleteEdit(declarationRule.getOffset() - amount, declarationRule.getLength() + amount);
				multiEdit.addChild(deleteEdit);
				TextEditGroup editGroup3 = new TextEditGroup("remove old line", deleteEdit);
				fileChange.addTextEditGroup(editGroup3);
				pm.worked(1);
			}
		}
		
		return compositeChange;
		
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringParticipant[] loadParticipants(RefactoringStatus status,
			SharableParticipants sharedParticipants) throws CoreException {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	
}