package de.ugoe.cs.swe.bnftools.ui.refactoring.inlinetokenrules;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import de.ugoe.cs.swe.bnftools.analysis.EbnfAnalysisUtils;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.utils.DeclarationReferencesPair;

public class InlineTokenRulesRefactoringProcessor extends RefactoringProcessor {
	IFile file;
	private CompositeNode rootNode;
	private List<DeclarationReferencesPair> nodePairs;

	// ----------------------------------------------------------------------------------------------------

	public InlineTokenRulesRefactoringProcessor(XtextEditor editor, CompositeNode root, XtextDocument doc,  List<DeclarationReferencesPair> nodePairs) {
		file = (IFile) editor.getEditorInput().getAdapter(IFile.class);
		this.rootNode = root;
		this.nodePairs = nodePairs;
	}
	
	// ----------------------------------------------------------------------------------------------------

	@Override
	public Object[] getElements() {
		return null;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getIdentifier() {
		return "Inline Token Rules Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public String getProcessorName() {
		return "Inline Token Rules Processor";
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public boolean isApplicable() throws CoreException {
		return (rootNode != null);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkInitialConditions(IProgressMonitor pm)
			throws CoreException, OperationCanceledException {
		
		RefactoringStatus status = new RefactoringStatus();

		if (rootNode == null)
			status.addFatalError("Root node is null!");

		return status;
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkFinalConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws CoreException,
			OperationCanceledException {
		
		return checkInitialConditions(pm);
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {

		CompositeChange compositeChange = new CompositeChange("Inline Token Rule");
		pm.beginTask("Inline Token Rules Refactoring", 2);
		
		//initialising the edit
		MultiTextEdit multiEdit = new MultiTextEdit();
		TextFileChange fileChange = new TextFileChange("Inline Token Rules", file);
		fileChange.setEdit(multiEdit);
		fileChange.setTextType("bnf");
		compositeChange.add(fileChange);
		
		// Inline Token Rules
		for (int i=0; i < nodePairs.size(); i++) {
			CompositeNode declarationRule = nodePairs.get(i).getDeclarationNode();
			List<CompositeNode> ruleReferences = nodePairs.get(i).getReferenceNodes();

			// get the replacement name
			StringRule stringRule = EbnfAnalysisUtils.getTokenRuleTerminal((Rule) declarationRule.getElement());
			String replaceString = "";
			if (stringRule.getLiteral().length() > 0) {
				replaceString = "\"" + stringRule.getLiteral() + "\""; 
			} else {
				replaceString = "\"\"\""; 
			}
			
			// replace references with passthrough rule name
			for (int j=0; j < ruleReferences.size(); j++) {
				CompositeNode ruleReference = ruleReferences.get(j);
				ReplaceEdit replaceEdit2 = new ReplaceEdit(ruleReference.getOffset(), ruleReference.getLength(), replaceString);
				multiEdit.addChild(replaceEdit2);
				TextEditGroup editGroup2 = new TextEditGroup("reference renaming", replaceEdit2);
				fileChange.addTextEditGroup(editGroup2);
				pm.worked(1);
			}
		}
		
		return compositeChange;
		
	}

	// ----------------------------------------------------------------------------------------------------

	@Override
	public RefactoringParticipant[] loadParticipants(RefactoringStatus status,
			SharableParticipants sharedParticipants) throws CoreException {
		return null;
	}

}