package de.ugoe.cs.swe.bnftools.ui.refactoring.rename;

import java.util.List;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;

import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.utils.EObjectSelectionResolver;
import de.ugoe.cs.swe.bnftools.utils.URIFragmentResolver;
import de.ugoe.cs.swe.bnftools.utils.Utils;

public class RenameProcessor extends
		org.eclipse.ltk.core.refactoring.participants.RenameProcessor {

	private List<CompositeNode> references = null;
	private String currentName;
	private CompositeNode declaration;
	private IFile file;

	// --------------------------------------------------------------------------------

	public RenameProcessor(XtextEditor editor,
			IResourceDescriptions resourceDescriptions) {
		
		final ITextSelection selection = (ITextSelection) editor
				.getSelectionProvider().getSelection();
		
		final IEObjectDescription eObjectDescription = editor.getDocument()
				.readOnly(new EObjectSelectionResolver(selection, resourceDescriptions));

		declaration = editor.getDocument().readOnly(
				new URIFragmentResolver(eObjectDescription.getEObjectURI()
						.fragment()));

		if (declaration.getElement() instanceof Rule) {
			Rule r = (Rule) declaration.getElement();
			currentName = r.getName();
		}

		file = (IFile) editor.getEditorInput().getAdapter(IFile.class);
		
		if (eObjectDescription != null) {
			references = Utils.findReferenceDescriptions(eObjectDescription, resourceDescriptions, editor);
		}

	}

	// --------------------------------------------------------------------------------

	@Override
	public Object[] getElements() {
		return null;
	}

	// --------------------------------------------------------------------------------

	@Override
	public String getIdentifier() {
		return "Rename Processor Identifier";
	}

	// --------------------------------------------------------------------------------

	@Override
	public String getProcessorName() {
		return "Rename Processor";
	}

	// --------------------------------------------------------------------------------

	@Override
	public boolean isApplicable() throws CoreException {
		return (references != null);
	}

	// --------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkInitialConditions(IProgressMonitor pm)
			throws CoreException, OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();

		if (references == null)
			status.addFatalError("Could not obtain references!");

		return status;
	}

	// --------------------------------------------------------------------------------

	@Override
	public RefactoringStatus checkFinalConditions(IProgressMonitor pm,
			CheckConditionsContext context) throws CoreException,
			OperationCanceledException {
		RefactoringStatus status = new RefactoringStatus();
		RenameRefactoring refactoring = (RenameRefactoring) getRefactoring();
		if (currentName.equals(refactoring.getRenameText())) {
			status.addFatalError("Name unchanged!");
		} else if (refactoring.getRenameText().length() <= 0) {
			status.addFatalError("name must not be empty!");
		}

		return status;
	}

	// --------------------------------------------------------------------------------

	@Override
	public Change createChange(IProgressMonitor pm) throws CoreException,
			OperationCanceledException {
		CompositeChange compositeChange = new CompositeChange("Rename");
		pm.beginTask("Rename Refactoring", references.size());

		MultiTextEdit multiEdit = new MultiTextEdit();
		TextFileChange fileChange = new TextFileChange("Declaraction Renaming", file);
		
		fileChange.setEdit(multiEdit);
		fileChange.setTextType("bnf");
		compositeChange.add(fileChange);
		
		RenameRefactoring refactoring = (RenameRefactoring) getRefactoring();
		String replaceText = refactoring.getRenameText();
		
		ReplaceEdit replaceEdit = new ReplaceEdit(declaration.getOffset(), ((Rule)declaration.getElement()).getName().length(), replaceText);
		multiEdit.addChild(replaceEdit);
		
		TextEditGroup editGroup = new TextEditGroup("declaration update", replaceEdit);
		fileChange.addTextEditGroup(editGroup);
		pm.worked(1);
		
		
		for (int i=0; i < references.size(); i++) {
			CompositeNode reference = references.get(i);
			
			replaceEdit = new ReplaceEdit(reference.getOffset(), ((Rule)declaration.getElement()).getName().length(), replaceText);
			multiEdit.addChild(replaceEdit);
			editGroup = new TextEditGroup("reference update", replaceEdit);
			fileChange.addTextEditGroup(editGroup);
			
			pm.worked(1);
		}

		return compositeChange;
	}

	// --------------------------------------------------------------------------------

	@Override
	public RefactoringParticipant[] loadParticipants(RefactoringStatus status,
			SharableParticipants sharedParticipants) throws CoreException {
		return null;
	}

	// --------------------------------------------------------------------------------


}
