package de.ugoe.cs.swe.bnftools.ui.refactoring.rename;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;

import com.google.inject.Inject;

import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.utils.EObjectSelectionResolver;
import de.ugoe.cs.swe.bnftools.utils.URIFragmentResolver;

public class RenameRefactoringHandler extends AbstractHandler {

	@Inject
	private IResourceDescriptions resourceDescriptions;

	// --------------------------------------------------------------------------------

	public Object execute(ExecutionEvent event) throws ExecutionException {
		try {
			String currentName = "";

			XtextEditor editor = (XtextEditor) HandlerUtil
					.getActiveEditor(event);

			final ITextSelection selection = (ITextSelection) editor
					.getSelectionProvider().getSelection();

			final IEObjectDescription eObjectDescription = editor
					.getDocument()
					.readOnly(
							new EObjectSelectionResolver(selection, resourceDescriptions));

			CompositeNode o = editor.getDocument().readOnly(
					new URIFragmentResolver(eObjectDescription.getEObjectURI()
							.fragment()));

			if (o.getElement() instanceof Rule) {
				Rule r = (Rule) o.getElement();
				currentName = r.getName();
			}
			
			RenameProcessor processor = new RenameProcessor(editor,
					resourceDescriptions);
			RenameRefactoring refactoring = new RenameRefactoring(processor);

			RenameRefactoringWizard wizard = new RenameRefactoringWizard(
					refactoring, RefactoringWizard.WIZARD_BASED_USER_INTERFACE);
			wizard.setRenameText(currentName);

			RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation(
					wizard);

			openOperation.run(Display.getCurrent().getActiveShell(),
					"Refactoring not possible!");

		} catch (Exception e) {
			MessageDialog.openInformation(
					Display.getDefault().getActiveShell(),
					"Rename Refactoring",
					"Error while applying refactoring to workbench/wizard: "
							+ e.getMessage());
			e.printStackTrace();
		}
		return null;
	}

}
