package de.ugoe.cs.swe.bnftools.ui.refactoring.rename;

import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.widgets.Composite;

public class RenameRefactoringWizard extends RefactoringWizard {

	private RenameInputWizardPage wizardPage;
	private String renameText = "";

	// ---------------------------------------------------------------------------

	public RenameRefactoringWizard(Refactoring refactoring, int flags) {
		super(refactoring, flags);
	}

	// ---------------------------------------------------------------------------

	@Override
	protected void addUserInputPages() {
		wizardPage = new RenameInputWizardPage("Refactoring");
		wizardPage.setRenameText(renameText);
		addPage(wizardPage);
	}

	// ---------------------------------------------------------------------------

	public void setRenameText(String s) {
		renameText = s;
		if (wizardPage != null)
			wizardPage.setRenameText(s);
	}

	// ---------------------------------------------------------------------------

	static class RenameInputWizardPage extends UserInputWizardPage {

		private RenamePageComposite composite;
		private String renameText;

		public RenameInputWizardPage(String name) {
			super(name);
			setTitle("Rename Refactoring");
			setDescription("Automated Refactoring to rename rule names, rule references etc."
					+ " with the possibility to automatically update references");
		}

		public void createControl(Composite parent) {
			composite = new RenamePageComposite(parent, 0);
			composite.getRenameText().setText(renameText);
			composite.getRenameText().selectAll();
			setControl(composite);
		}

		public String getRenameText() {
			return composite.getRenameText().getText();
		}

		public void setRenameText(String s) {
			renameText = s;
			if (composite != null)
				composite.getRenameText().setText(renameText);
		}

		@Override
		public IWizardPage getNextPage() {
			RenameRefactoring refactoring = (RenameRefactoring) getRefactoring();
			if (refactoring != null) {
				refactoring.setRenameText(getRenameText());
			}
			return super.getNextPage();
		}

		@Override
		protected boolean performFinish() {
			RenameRefactoring refactoring = (RenameRefactoring) getRefactoring();
			if (refactoring != null) {
				refactoring.setRenameText(getRenameText());
			}

			return super.performFinish();
		}
	}

}
