package de.ugoe.cs.swe.bnftools.ui.syntaxcoloring;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.xtext.ui.editor.syntaxcoloring.DefaultHighlightingConfiguration;
import org.eclipse.xtext.ui.editor.syntaxcoloring.IHighlightingConfigurationAcceptor;
import org.eclipse.xtext.ui.editor.utils.TextStyle;

public class EtsiBnfHighlightingConfiguration extends DefaultHighlightingConfiguration {

	public static final String ID_ID = "Id";
	public static final String CROSSREF_ID = "Crossreference";
	public static final String OPERATOR_ID = "Operator";
	public static final String PARENTHESES_ID = "Parentheses";
	public static final String RULENAME_ID = "Rule Name";
	public static final String TOKENRULE_ID = "Token Rule";
	public static final String SECTIONHEADER_ID = "Section Header";

	@Override
	public void configure(IHighlightingConfigurationAcceptor acceptor) {
		super.configure(acceptor);
		acceptor.acceptDefaultHighlighting(ID_ID, "Rule Id", IdTextStyle());
		acceptor.acceptDefaultHighlighting(OPERATOR_ID, "Operator", OperatorTextStyle());
		acceptor.acceptDefaultHighlighting(PARENTHESES_ID, "Parentheses", ParenthesesTextStyle());
		acceptor.acceptDefaultHighlighting(CROSSREF_ID, "Rule Crossreference", CrossreferenceTextStyle());
		acceptor.acceptDefaultHighlighting(RULENAME_ID, "Rule Name", RuleNameTextStyle());
		acceptor.acceptDefaultHighlighting(TOKENRULE_ID, "Token Rule", TokenRuleTextStyle());
		acceptor.acceptDefaultHighlighting(SECTIONHEADER_ID, "SectionHeader", SectionHeaderTextStyle());
	}

	public TextStyle IdTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(60, 60, 60));
		return textStyle;
	}

	public TextStyle RuleNameTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(60, 60, 60));
		textStyle.setBackgroundColor(new RGB(200,255,200));
		textStyle.setStyle(SWT.BOLD);
		return textStyle;
	}

	public TextStyle TokenRuleTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(60, 60, 60));
		textStyle.setBackgroundColor(new RGB(255,200,255));
		textStyle.setStyle(SWT.BOLD);
		return textStyle;
	}

	public TextStyle SectionHeaderTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(255, 255, 255));
		textStyle.setBackgroundColor(new RGB(120,120,120));
		textStyle.setStyle(SWT.BOLD);
		return textStyle;
	}

	public TextStyle CrossreferenceTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(60, 60, 60));
		textStyle.setStyle(SWT.ITALIC);
		return textStyle;
	}

	public TextStyle OperatorTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(200, 100, 0));
		return textStyle;
	}

	public TextStyle ParenthesesTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(255, 0, 255));
		return textStyle;
	}

	public TextStyle punctuationTextStyle() {
		TextStyle textStyle = new TextStyle();
		textStyle.setColor(new RGB(255, 0, 0));
		textStyle.setStyle(SWT.BOLD);
		return textStyle;
	}
	
}
