package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;

public class NonTerminalFigure extends SyntaxDiagramFigure {
	private String nonterminalString;

	public NonTerminalFigure(String nonterminalString) {
		super();
		this.nonterminalString = nonterminalString;

		SyntaxDiagramFigure innerFigure = new SyntaxDiagramFigure();
		setBorder(new LineMarginBorder(0, 0, 0));
		innerFigure.setLayoutManager(new StackLayout());

	    FlowLayout layout = new FlowLayout();
	    layout.setMajorAlignment(FlowLayout.ALIGN_CENTER);
	    setLayoutManager(layout);	

		RectangleFigure rectangle = new RectangleFigure();
		rectangle.setAntialias(SWT.ON);
		rectangle.setBackgroundColor(new Color(null, 220, 220, 220));
		rectangle.setForegroundColor(new Color(null, 170, 170, 170));
		innerFigure.add(rectangle);
		
		Label nonterminalStringLabel = new Label(this.nonterminalString);
		nonterminalStringLabel.setForegroundColor(new Color(null, 200, 0, 0));
		nonterminalStringLabel.setTextAlignment(PositionConstants.CENTER);
		nonterminalStringLabel.setBorder(new MarginBorder(3,8,3,8));
		innerFigure.add(nonterminalStringLabel);
		
		PathFigure leftPath = new PathFigure();
		leftPath.setSourceAnchor(this.getLeftAnchor());
		leftPath.setTargetAnchor(innerFigure.getLeftAnchor());

		PathFigure rightPath = new PathFigure();
		rightPath.setTargetDecoration(null);
		rightPath.setSourceAnchor(innerFigure.getRightAnchor());
		rightPath.setTargetAnchor(this.getRightAnchor());
		
		add(leftPath);
		add(rightPath);
		
		add(innerFigure);
	}

	public String getTerminalString() {
		return nonterminalString;
	}

	public void setTerminalString(String terminalString) {
		this.nonterminalString = terminalString;
	}

}
