package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.ui.editor.XtextEditor;

import de.ugoe.cs.swe.bnftools.utils.Utils;

public class SyntaxDiagramView extends ViewPart {

	public static final String ID = "org.etsi.bnftools.views.syntaxdiagram.SyntaxDiagramView"; //$NON-NLS-1$

	private FigureCanvas canvas;

	public SyntaxDiagramView() {
	}

	public void createPartControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NONE);

		container.setLayout(new FillLayout());
		canvas = new FigureCanvas(container, SWT.V_SCROLL | SWT.H_SCROLL);
		canvas.setViewport(new Viewport(true));
		canvas.setScrollBarVisibility(FigureCanvas.ALWAYS);

		createActions();
		initializeToolBar();
		initializeMenu();

		getSite().getWorkbenchWindow().getSelectionService()
				.addPostSelectionListener(new ISelectionListener() {
					public void selectionChanged(IWorkbenchPart part,
							ISelection selection) {
						if (selection instanceof ITextSelection) {
							IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
							if (activePage == null)
								return;
							IEditorPart activeEditor = activePage.getActiveEditor();
							if (activeEditor == null)
								return;
							XtextEditor xtextEditor = (XtextEditor) activeEditor.getAdapter(XtextEditor.class);
							
							ITextSelection mySelection = (ITextSelection) selection;

							if ((xtextEditor != null) && (mySelection != null)) {
								NodeAdapter node = Utils.findNodeFromSelection(
										xtextEditor, mySelection);
								if (node != null)
									draw(node);
							}
						}
					}
				});
	}

	public void draw(NodeAdapter node) {
		Figure mainFigure = new Figure();
		mainFigure.setBounds(new Rectangle(canvas.getBounds()));
		ToolbarLayout mainLayout = new ToolbarLayout();
		mainLayout.setStretchMinorAxis(false);
		mainLayout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
		mainFigure.setLayoutManager(mainLayout);
		mainFigure.setOpaque(true);
		mainFigure.setBackgroundColor(ColorConstants.white);
		mainFigure.setBorder(new MarginBorder(10));

		canvas.setContents(mainFigure);

		LightweightSystem lws = new LightweightSystem(canvas);
		lws.setContents(canvas.getViewport());

		SyntaxDiagramFigure newSyntaxDiagram = new SyntaxDiagramCreator(node).createSyntaxDiagram();
		
		mainFigure.add(newSyntaxDiagram);
	}

	private void createActions() {
		// Create the actions
	}

	private void initializeToolBar() {
		// IToolBarManager toolbarManager = getViewSite().getActionBars()
		// .getToolBarManager();
	}

	private void initializeMenu() {
		// IMenuManager menuManager = getViewSite().getActionBars()
		// .getMenuManager();
	}

	@Override
	public void setFocus() {
		// Set the focus
	}

}