package de.ugoe.cs.swe.bnftools.utils;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.xtext.builder.builderState.impl.ReferenceDescriptionImpl;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IReferenceDescription;
import org.eclipse.xtext.resource.IResourceDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;

import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;

public class Utils {
	
	static public NodeAdapter findNodeFromSelection(
			final XtextEditor xtextEditor, ITextSelection mySelection) {
		NodeAdapter node = null;
		if ((xtextEditor == null) || (xtextEditor.getDocument() == null))
			return null;
		EtsiBnf root = (EtsiBnf) xtextEditor.getDocument().readOnly(
				new RootEObjectFinder());
		EList<Rule> rules = root.getRule();
		for (int i = 0; i < rules.size(); i++) {
			node = NodeUtil.getNodeAdapter(rules.get(i));
			if ((node.getParserNode().getOffset() <= mySelection.getOffset())
					&& (mySelection.getOffset() <= node.getParserNode()
							.getOffset()
							+ node.getParserNode().getLength())) {
				return node;
			}
		}
		return null;
	}
	
	// --------------------------------------------------------------------------------

	static public List<CompositeNode> findReferenceDescriptions(
			final IEObjectDescription eObjectDescription, IResourceDescriptions resourceDescriptions, XtextEditor editor) {
//TODO: resolved nur innerhalb derselben datei!
		List<CompositeNode> references = new ArrayList<CompositeNode>();

		for (IResourceDescription resourceDescription : resourceDescriptions
				.getAllResourceDescriptions()) {
			Iterable<IReferenceDescription> matchingReferenceDescriptors = Iterables
					.filter(resourceDescription.getReferenceDescriptions(),
							new Predicate<IReferenceDescription>() {
								public boolean apply(IReferenceDescription input) {
									return eObjectDescription
											.getEObjectURI()
											.equals(input.getTargetEObjectUri());
								}
							});
			for (IReferenceDescription matchingReferenceDescription : matchingReferenceDescriptors) {
//TODO: dieser check ignoriert links zu anderen dateien wg. exception
				if ((matchingReferenceDescription instanceof org.eclipse.xtext.resource.impl.DefaultReferenceDescription) || (matchingReferenceDescription instanceof ReferenceDescriptionImpl)){
					CompositeNode node = editor.getDocument().readOnly(
							new URIFragmentResolver(matchingReferenceDescription
									.getSourceEObjectUri().fragment()));
					references.add(node);
				}
			}
		}
		return references;
	}

	// --------------------------------------------------------------------------------

	static public List<CompositeNode> findReferences(EObject o, IResourceDescriptions resourceDescriptions, XtextEditor editor) {
		final IEObjectDescription eObjectDescription = editor.getDocument()
		.readOnly(new EObjectResolver(o, resourceDescriptions));

		List<CompositeNode> referenceDescriptions = Utils.findReferenceDescriptions(eObjectDescription, resourceDescriptions, editor);
		return referenceDescriptions;
	}
	
	// --------------------------------------------------------------------------------

	static public int stepBackNewlines(IXtextDocument document, int offset) {
		if (offset <= 0)
			return 0;
		
		try {
			int tempOffset = offset;
			String str = document.get(tempOffset-1, 1);
			while (str.equals("\n") || str.equals("\r") || str.equals(" ")) {
				tempOffset -= 1;
				str = document.get(tempOffset-1, 1);
			}
			return offset - tempOffset;
		} catch (BadLocationException e) {
			e.printStackTrace();
		}
		return 0;
	}

}
