package de.ugoe.cs.swe.bnftools.ui.formatter;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;

public class FormatterHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();

		// TODO: better error handling
		if (!(editor.getDocument() instanceof XtextDocument)) {
			return null;
		}

		XtextDocument doc = (XtextDocument) editor.getDocument();
		EObject root = doc.readOnly(new RootEObjectFinder());
		NodeAdapter rootNode = NodeUtil.getNodeAdapter(root);

		FormatterProcessor processor = new FormatterProcessor(editor,
				rootNode.getParserNode(), doc);

		FormatterRefactoring refactoring = new FormatterRefactoring(processor);
		
		try {
			performRefactoring(refactoring);
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		} catch (Exception e) {
			e.printStackTrace();
		}

		return null;
	}

	public void performRefactoring(ProcessorBasedRefactoring ref)
			throws Exception {
		NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
		RefactoringStatus status = ref.checkAllConditions(nullProgressMonitor);
		if (status.isOK()) {
			Change change = ref.createChange(nullProgressMonitor);
			change.initializeValidationData(nullProgressMonitor);
			change.setEnabled(true);
			PerformChangeOperation operation = new PerformChangeOperation(
					change);
			operation.setUndoManager(RefactoringCore.getUndoManager(),
					ref.getProcessor().getProcessorName());
			operation.run(nullProgressMonitor);
			change.dispose();
		} else {
			MessageDialog.openInformation(
					Display.getDefault().getActiveShell(), "Custom Formatter",
					status.getMessageMatchingSeverity(status.getSeverity()));
		}
	}

}
