/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.intermediate;

import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.apache.fop.traits.BorderProps;
import org.apache.fop.traits.RuleStyle;

public abstract class BorderPainter {
    public void drawBorders(Rectangle borderRect, BorderProps bpsTop, BorderProps bpsBottom, BorderProps bpsLeft, BorderProps bpsRight) throws IOException {
        int ey1a;
        int sy1a;
        int innerx;
        int clipx;
        int outerx;
        int ey2;
        int ey1;
        int sy2;
        int sy1;
        int ex1a;
        int sx1a;
        int innery;
        int clipy;
        int outery;
        int ex2;
        int ex1;
        int sx2;
        int sx1;
        int startx = borderRect.x;
        int starty = borderRect.y;
        int width = borderRect.width;
        int height = borderRect.height;
        boolean[] b = new boolean[]{bpsTop != null, bpsRight != null, bpsBottom != null, bpsLeft != null};
        if (!(b[0] || b[1] || b[2] || b[3])) {
            return;
        }
        int[] bw = new int[]{b[0] ? bpsTop.width : 0, b[1] ? bpsRight.width : 0, b[2] ? bpsBottom.width : 0, b[3] ? bpsLeft.width : 0};
        int[] clipw = new int[]{BorderProps.getClippedWidth(bpsTop), BorderProps.getClippedWidth(bpsRight), BorderProps.getClippedWidth(bpsBottom), BorderProps.getClippedWidth(bpsLeft)};
        starty += clipw[0];
        height -= clipw[0];
        height -= clipw[2];
        startx += clipw[3];
        width -= clipw[3];
        width -= clipw[1];
        boolean[] slant = new boolean[]{b[3] && b[0], b[0] && b[1], b[1] && b[2], b[2] && b[3]};
        if (bpsTop != null) {
            sx1 = startx;
            sx2 = slant[0] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[1] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty - clipw[0];
            clipy = outery + clipw[0];
            innery = outery + bw[0];
            this.saveGraphicsState();
            this.moveTo(sx1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsTop.mode == 2) {
                if (bpsLeft != null && bpsLeft.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsRight != null && bpsRight.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(sx1a, outery);
                this.lineTo(ex1a, outery);
            }
            this.lineTo(ex1, clipy);
            this.lineTo(ex2, innery);
            this.lineTo(sx2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, outery, ex1a, innery, true, true, bpsTop.style, bpsTop.color);
            this.restoreGraphicsState();
        }
        if (bpsRight != null) {
            sy1 = starty;
            sy2 = slant[1] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = starty + height;
            ey2 = slant[2] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx + width + clipw[1];
            clipx = outerx - clipw[1];
            innerx = outerx - bw[1];
            this.saveGraphicsState();
            this.moveTo(clipx, sy1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsRight.mode == 2) {
                if (bpsTop != null && bpsTop.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsBottom != null && bpsBottom.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, sy1a);
                this.lineTo(outerx, ey1a);
            }
            this.lineTo(clipx, ey1);
            this.lineTo(innerx, ey2);
            this.lineTo(innerx, sy2);
            this.closePath();
            this.clip();
            this.drawBorderLine(innerx, sy1a, outerx, ey1a, false, false, bpsRight.style, bpsRight.color);
            this.restoreGraphicsState();
        }
        if (bpsBottom != null) {
            sx1 = startx;
            sx2 = slant[3] ? sx1 + bw[3] - clipw[3] : sx1;
            ex1 = startx + width;
            ex2 = slant[2] ? ex1 - bw[1] + clipw[1] : ex1;
            outery = starty + height + clipw[2];
            clipy = outery - clipw[2];
            innery = outery - bw[2];
            this.saveGraphicsState();
            this.moveTo(ex1, clipy);
            sx1a = sx1;
            ex1a = ex1;
            if (bpsBottom.mode == 2) {
                if (bpsLeft != null && bpsLeft.mode == 2) {
                    sx1a -= clipw[3];
                }
                if (bpsRight != null && bpsRight.mode == 2) {
                    ex1a += clipw[1];
                }
                this.lineTo(ex1a, outery);
                this.lineTo(sx1a, outery);
            }
            this.lineTo(sx1, clipy);
            this.lineTo(sx2, innery);
            this.lineTo(ex2, innery);
            this.closePath();
            this.clip();
            this.drawBorderLine(sx1a, innery, ex1a, outery, true, false, bpsBottom.style, bpsBottom.color);
            this.restoreGraphicsState();
        }
        if (bpsLeft != null) {
            sy1 = starty;
            sy2 = slant[0] ? sy1 + bw[0] - clipw[0] : sy1;
            ey1 = sy1 + height;
            ey2 = slant[3] ? ey1 - bw[2] + clipw[2] : ey1;
            outerx = startx - clipw[3];
            clipx = outerx + clipw[3];
            innerx = outerx + bw[3];
            this.saveGraphicsState();
            this.moveTo(clipx, ey1);
            sy1a = sy1;
            ey1a = ey1;
            if (bpsLeft.mode == 2) {
                if (bpsTop != null && bpsTop.mode == 2) {
                    sy1a -= clipw[0];
                }
                if (bpsBottom != null && bpsBottom.mode == 2) {
                    ey1a += clipw[2];
                }
                this.lineTo(outerx, ey1a);
                this.lineTo(outerx, sy1a);
            }
            this.lineTo(clipx, sy1);
            this.lineTo(innerx, sy2);
            this.lineTo(innerx, ey2);
            this.closePath();
            this.clip();
            this.drawBorderLine(outerx, sy1a, innerx, ey1a, false, true, bpsLeft.style, bpsLeft.color);
            this.restoreGraphicsState();
        }
    }

    protected abstract void drawBorderLine(int var1, int var2, int var3, int var4, boolean var5, boolean var6, int var7, Color var8) throws IOException;

    public abstract void drawLine(Point var1, Point var2, int var3, Color var4, RuleStyle var5) throws IOException;

    protected abstract void moveTo(int var1, int var2) throws IOException;

    protected abstract void lineTo(int var1, int var2) throws IOException;

    protected abstract void closePath() throws IOException;

    protected abstract void clip() throws IOException;

    protected abstract void saveGraphicsState() throws IOException;

    protected abstract void restoreGraphicsState() throws IOException;
}

