/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.awt;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.io.IOException;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.area.Area;
import org.apache.fop.area.PageViewport;
import org.apache.fop.render.awt.viewer.PreviewDialog;
import org.apache.fop.render.awt.viewer.Renderable;
import org.apache.fop.render.awt.viewer.StatusListener;
import org.apache.fop.render.extensions.prepress.PageScale;
import org.apache.fop.render.java2d.Java2DRenderer;

public class AWTRenderer
extends Java2DRenderer
implements Pageable {
    public static final String MIME_TYPE = "application/X-fop-awt-preview";
    public boolean debug;
    protected StatusListener statusListener = null;

    public AWTRenderer(FOUserAgent userAgent) {
        this(userAgent, null, false, false);
    }

    public AWTRenderer(FOUserAgent userAgent, Renderable renderable, boolean previewAsMainWindow, boolean show) {
        super(userAgent);
        if (show) {
            this.setStatusListener(PreviewDialog.createPreviewDialog(userAgent, renderable, previewAsMainWindow));
        }
    }

    public void renderPage(PageViewport pageViewport) throws IOException, FOPException {
        super.renderPage(pageViewport);
        if (this.statusListener != null) {
            this.statusListener.notifyPageRendered();
        }
    }

    public void stopRenderer() throws IOException {
        super.stopRenderer();
        if (this.statusListener != null) {
            this.statusListener.notifyRendererStopped();
        }
    }

    public Dimension getPageImageSize(int pageNum) throws FOPException {
        String scale;
        Point2D scales;
        Rectangle bounds = this.getPageViewport(pageNum).getViewArea();
        this.pageWidth = (int)Math.round(((RectangularShape)bounds).getWidth() / 1000.0);
        this.pageHeight = (int)Math.round(((RectangularShape)bounds).getHeight() / 1000.0);
        double scaleX = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
        double scaleY = this.scaleFactor * 0.35277777910232544 / (double)this.userAgent.getTargetPixelUnitToMillimeter();
        if (this.getPageViewport(pageNum).getForeignAttributes() != null && (scales = PageScale.getScale(scale = this.getPageViewport(pageNum).getForeignAttributes().get(PageScale.EXT_PAGE_SCALE))) != null) {
            scaleX *= scales.getX();
            scaleY *= scales.getY();
        }
        int bitmapWidth = (int)((double)this.pageWidth * scaleX + 0.5);
        int bitmapHeight = (int)((double)this.pageHeight * scaleY + 0.5);
        return new Dimension(bitmapWidth, bitmapHeight);
    }

    public PageFormat getPageFormat(int pageIndex) throws IndexOutOfBoundsException {
        try {
            double height;
            if (pageIndex >= this.getNumberOfPages()) {
                return null;
            }
            PageFormat pageFormat = new PageFormat();
            Paper paper = new Paper();
            Rectangle dim = this.getPageViewport(pageIndex).getViewArea();
            double width = ((RectangularShape)dim).getWidth();
            if (width > (height = ((RectangularShape)dim).getHeight())) {
                paper.setImageableArea(0.0, 0.0, height / 1000.0, width / 1000.0);
                paper.setSize(height / 1000.0, width / 1000.0);
                pageFormat.setOrientation(0);
            } else {
                paper.setImageableArea(0.0, 0.0, width / 1000.0, height / 1000.0);
                paper.setSize(width / 1000.0, height / 1000.0);
                pageFormat.setOrientation(1);
            }
            pageFormat.setPaper(paper);
            return pageFormat;
        }
        catch (FOPException fopEx) {
            throw new IndexOutOfBoundsException(fopEx.getMessage());
        }
    }

    public Printable getPrintable(int pageIndex) throws IndexOutOfBoundsException {
        return this;
    }

    public boolean supportsOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    protected void drawBackAndBorders(Area area, float startx, float starty, float width, float height) {
        if (this.debug) {
            this.debugBackAndBorders(area, startx, starty, width, height);
        }
        super.drawBackAndBorders(area, startx, starty, width, height);
    }

    private void debugBackAndBorders(Area area, float startx, float starty, float width, float height) {
        this.saveGraphicsState();
        Color col = new Color(0.7f, 0.7f, 0.7f);
        this.state.updateColor(col);
        this.state.updateStroke(0.4f, 133);
        this.state.getGraph().draw(new Rectangle2D.Float(startx, starty, width, height));
        this.restoreGraphicsState();
    }

    public StatusListener getStatusListener() {
        return this.statusListener;
    }

    public void setStatusListener(StatusListener statusListener) {
        this.statusListener = statusListener;
    }
}

