/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf.extensions;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.pdf.extensions.PDFEmbeddedFileExtensionAttachment;
import org.apache.fop.render.pdf.extensions.PDFExtensionAttachment;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class PDFExtensionHandler
extends DefaultHandler
implements ContentHandlerFactory.ObjectSource {
    protected static final Log log = LogFactory.getLog(PDFExtensionHandler.class);
    private Attributes lastAttributes;
    private PDFExtensionAttachment returnedObject;
    private ContentHandlerFactory.ObjectBuiltListener listener;

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        boolean handled = false;
        if ("apache:fop:extensions:pdf".equals(uri)) {
            this.lastAttributes = new AttributesImpl(attributes);
            handled = false;
            if (localName.equals("embedded-file")) {
                handled = true;
            }
        }
        if (!handled) {
            if ("apache:fop:extensions:pdf".equals(uri)) {
                throw new SAXException("Unhandled element " + localName + " in namespace: " + uri);
            }
            log.warn((Object)("Unhandled element " + localName + " in namespace: " + uri));
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("apache:fop:extensions:pdf".equals(uri) && "embedded-file".equals(localName)) {
            String name = this.lastAttributes.getValue("name");
            String src = this.lastAttributes.getValue("src");
            String desc = this.lastAttributes.getValue("description");
            this.returnedObject = new PDFEmbeddedFileExtensionAttachment(name, src, desc);
        }
    }

    public void endDocument() throws SAXException {
        if (this.listener != null) {
            this.listener.notifyObjectBuilt(this.getObject());
        }
    }

    public Object getObject() {
        return this.returnedObject;
    }

    public void setObjectBuiltListener(ContentHandlerFactory.ObjectBuiltListener listener) {
        this.listener = listener;
    }
}

