package de.ugoe.cs.swe.bnftools.ui.formatter;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.DeltaEntry;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.Import;
import de.ugoe.cs.swe.bnftools.ebnf.ImportSection;
import de.ugoe.cs.swe.bnftools.ebnf.MergeEntry;
import de.ugoe.cs.swe.bnftools.ebnf.MergeRule;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;
import de.ugoe.cs.swe.bnftools.visitor.EbnfVisitor;

public class EbnfFormatterVisitor extends EbnfVisitor {
	private StringBuffer buf;
	private FormatterConfig config;

	public EbnfFormatterVisitor(EObject rootNode, FormatterConfig config) {
		super(rootNode);
		this.config = config;
		buf = new StringBuffer();
	}

	public EbnfFormatterVisitor(FormatterConfig config) {
		this.config = config;
		buf = new StringBuffer();
	}

	public StringBuffer getBuf() {
		return buf;
	}

	// -----------------------------------------------------------------------------

	protected void visitBefore(EtsiBnf node) {
		buf.append("grammar " + node.getName());
		if (node.getType() != null)
			buf.append(node.getType());
		buf.append(";");
		buf.append("\n");
	}

	protected void visitAfter(EtsiBnf node) {
	}

	protected void visitBefore(ImportSection node) {
		buf.append("\n");
	}

	protected void visitAfter(ImportSection node) {
		buf.append("\n");
	}

	protected void visitBefore(BnfEntry node) {
	}

	protected void visitAfter(BnfEntry node) {
	}
	
	protected void visitBefore(DeltaEntry node) {
	}

	protected void visitAfter(DeltaEntry node) {
	}
	
	protected void visitBefore(MergeEntry node) {
	}

	protected void visitAfter(MergeEntry node) {
	}
	
	protected void visitBefore(Atom node) {
	}

	protected void visitAfter(Atom node) {
	}

	protected void visitBefore(Term node) {
	}

	protected void visitAfter(Term node) {
		if (!isLastElement())
			buf.append(" ");
	}

	protected void visitBefore(DefinitionList node) {
	}

	protected void visitAfter(DefinitionList node) {
	}

	protected void visitBefore(ExtRule node) {
	}

	protected void visitAfter(ExtRule node) {
	}

	protected void visitBefore(GlobalCombinator node) {
	}

	protected void visitAfter(GlobalCombinator node) {
	}

	protected void visitBefore(GroupedSequence node) {
		buf.append("(");
	}

	protected void visitAfter(GroupedSequence node) {
		buf.append(")");
	}

	protected void visitBefore(HookCombinator node) {
	}

	protected void visitAfter(HookCombinator node) {
	}

	protected void visitBefore(Import node) {
		buf.append("import \"" + node.getImportURI() + "\";\n");
	}

	protected void visitAfter(Import node) {
	}

	protected void visitBefore(MergeRule node) {
	}

	protected void visitAfter(MergeRule node) {
	}

	protected void visitBefore(OptionalSequence node) {
		buf.append("[");
	}

	protected void visitAfter(OptionalSequence node) {
		buf.append("]");
	}

	protected void visitBefore(RepeatedSequence node) {
		buf.append("{");
	}

	protected void visitAfter(RepeatedSequence node) {
		buf.append("}");
		if (node.isMorethanonce())
			buf.append("+");
	}

	protected void visitBefore(Rule node) {
		if (node.getRulenumber() > 0)
			buf.append(node.getRulenumber() + ". ");
		
		buf.append(node.getName() + " ::= ");
	}

	protected void visitAfter(Rule node) {
		buf.append(";\n");
	}

	protected void visitBefore(RuleCombinator node) {
	}

	protected void visitAfter(RuleCombinator node) {
	}

	protected void visitBefore(RuleReference node) {
		buf.append(node.getRuleref().getName());
	}

	protected void visitAfter(RuleReference node) {
	}

	protected void visitBefore(SectionHeading node) {
		if (!buf.substring(buf.length()-2).equals("\n\n"))
			buf.append("\n");
		
		buf.append(node.getSectionHeader());
	}

	protected void visitAfter(SectionHeading node) {
		buf.append("\n");
	}

	protected void visitBefore(SingleDefinition node) {
	}

	protected void visitAfter(SingleDefinition node) {
		if (!isLastElement())
			buf.append(" | ");
		
	}

	protected void visitBefore(StringRule node) {
		if (node.getLiteral() != null)
			buf.append("\"" + node.getLiteral() + "\"");
		else if (node.getColon() != null)
			buf.append("\"\"\"");
	}

	protected void visitAfter(StringRule node) {
	}

	
	
}
