package de.ugoe.cs.swe.bnftools.ui.formatter;

import java.util.ArrayList;
import java.util.Iterator;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;

import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.Import;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;

public class EbnfHtmlFormatterVisitor extends EbnfFormatterVisitor {

	private ArrayList<MetaTextEntry> metaTexts = new ArrayList<MetaTextEntry>();
	private ArrayList<MetaTextEntry> transformedTexts = new ArrayList<MetaTextEntry>();
	private int lastMetaTextBlock = 0;
	private boolean isParagraphOpen = false;
	
	public EbnfHtmlFormatterVisitor(EObject rootNode, FormatterConfig config) {
		super(rootNode, config);
		this.config = config;
		buf = new StringBuffer();
	}

	protected void weaveComments() {
		bufferPositionOriginalText = 0;
		bufferPositionFormattedTextNoWhitespaces = 0;
		bufferPositionFormattedText = 0;
		
		StringBuffer result = new StringBuffer();
		formattedTextNoWhitespaces = buf.toString().replaceAll("[ \t\n\r]", "");
		formattedText = buf.toString();

		MetaTextEntry currentMetaText = null;
		if (metaTexts.iterator().hasNext())
			currentMetaText = metaTexts.iterator().next();

		MetaTextEntry currentTransformedText = null;
		if (transformedTexts.iterator().hasNext())
			currentTransformedText = transformedTexts.iterator().next();
		
		while (bufferPositionFormattedTextNoWhitespaces <= formattedTextNoWhitespaces.length()) {
			skipWhitespacesOriginalText();
			skipWhitespacesFormattedText(result);
			
			if (!(bufferPositionOriginalText < originalText.length()))
				break;
			
			char formattedPositionNoWhitespaces;
			if (bufferPositionFormattedTextNoWhitespaces == formattedTextNoWhitespaces.length()) {
				formattedPositionNoWhitespaces = ' ';
			} else {
				formattedPositionNoWhitespaces = formattedTextNoWhitespaces.charAt(bufferPositionFormattedTextNoWhitespaces);
			}
			char originalPosition = originalText.charAt(bufferPositionOriginalText);
			
			String commentPrefix = "<span lang=EN-GB style='color:green;mso-no-proof:no'>";
			String commentSuffix = "<o:p></o:p></span>";

			if (formattedPositionNoWhitespaces != originalPosition) {
//				if ((currentMetaText != null) && (bufferPositionFormattedTextNoWhitespaces == currentMetaText.getOffset())) {
//					result.append(currentMetaText.getText());
//					metaTexts.remove(currentMetaText);
//					if (metaTexts.iterator().hasNext())
//						currentMetaText = metaTexts.iterator().next();
//					else
//						currentMetaText = null;
//				}

				if (formattedPositionNoWhitespaces == ';') { // formatted text always outputs the optional semicolon, skip it if necessary
					bufferPositionFormattedTextNoWhitespaces++;
					bufferPositionFormattedText++;
				} else if (isCommentNext(originalText, bufferPositionOriginalText)) {
					LeafNode currentComment = allComments.get(allCommentsPosition); 
					if (currentComment.getTotalOffset() == bufferPositionOriginalText) {
						if (isMultiLineComment(currentComment.getText())) {
							int newLinesCount = scanBackNewlinesCount(originalText, bufferPositionOriginalText-1);
							if (newLinesCount > 0) {
								if (scanBackNewlinesCount(result.toString(), result.toString().length()-1) == 0) {
//									result.append("\n\n");
//									result.append("<p>");
								}
								result.append("\n<br/><br/>");
								result.append(commentPrefix + currentComment.getText() + commentSuffix);
//								result.append("\n");
								result.append("\n<br/>");
//								result.append("<p/>");
							} else {
								String lastWhiteSpaces = scanBackWhitespaces(result.toString(), result.toString().length()-1);
								result.delete(result.toString().length() - lastWhiteSpaces.length(), result.toString().length());
//								result.append(" " + stripEndingNewline(currentComment.getText()));
								result.append("&nbsp;" + commentPrefix + stripEndingNewline(currentComment.getText()) + commentSuffix);
								result.append(lastWhiteSpaces);
							}
						} else if (isSingleLineComment(currentComment.getText())) {
							int newLinesCount = scanBackNewlinesCount(originalText, bufferPositionOriginalText-1);
							String lastWhiteSpaces = scanBackWhitespaces(result.toString(), result.toString().length()-1);
							result.delete(result.toString().length() - lastWhiteSpaces.length(), result.toString().length());
							if (newLinesCount > 0) {
//								result.append("\n\n" + stripEndingNewline(currentComment.getText()));
								result.append("<br/><br/>" + commentPrefix + stripEndingNewline(currentComment.getText()) + commentSuffix);
							} else {
//								result.append(" " + stripEndingNewline(currentComment.getText()));
								result.append("&nbsp;" + commentPrefix + stripEndingNewline(currentComment.getText()) + commentSuffix);
							}
							result.append(lastWhiteSpaces);
						}
						bufferPositionOriginalText+=currentComment.getLength();
						allCommentsPosition++;
					}
				} else { // disaster handling: return original unformatted text!
					System.err.println("Disaster Recovery: returning original text!!");
					buf = new StringBuffer();
					buf.append(originalText);
					return;
				}
			} else {
				while (lastMetaTextBlock == 0 && (currentMetaText != null) && (bufferPositionFormattedTextNoWhitespaces >= currentMetaText.getOffset())) {
					result.append(currentMetaText.getText());
					metaTexts.remove(currentMetaText);
					if (metaTexts.iterator().hasNext())
						currentMetaText = metaTexts.iterator().next();
					else
						currentMetaText = null;
					
					if ((currentMetaText == null) && (bufferPositionFormattedTextNoWhitespaces != currentMetaText.getOffset()))
						lastMetaTextBlock = 1;
				}

				if (currentTransformedText != null && currentTransformedText.getOffset() == bufferPositionFormattedTextNoWhitespaces) {
					result.append(currentTransformedText.getTransformedText());
					bufferPositionOriginalText += currentTransformedText.getText().length();
					bufferPositionFormattedText += currentTransformedText.getText().length();
					bufferPositionFormattedTextNoWhitespaces += currentTransformedText.getText().replaceAll("[ \t\r\n]", "").length();
					transformedTexts.remove(currentTransformedText);
					currentTransformedText = null;
					
					if (transformedTexts.iterator().hasNext())
						currentTransformedText = transformedTexts.iterator().next();
				} else {
					String text = formattedText.substring(bufferPositionFormattedText, bufferPositionFormattedText+1);
					result.append(text);
					bufferPositionOriginalText++;
					bufferPositionFormattedText++;
					bufferPositionFormattedTextNoWhitespaces++;
				}

				while ( lastMetaTextBlock == 1 && currentMetaText != null && bufferPositionFormattedTextNoWhitespaces >= currentMetaText.getOffset()) {
					result.append(currentMetaText.getText());
					metaTexts.remove(currentMetaText);
					if (metaTexts.iterator().hasNext()) {
						currentMetaText = metaTexts.iterator().next();
					} else {
						currentMetaText = null;
					}
					
					if ((currentMetaText == null) || (bufferPositionFormattedTextNoWhitespaces != currentMetaText.getOffset()))
						lastMetaTextBlock = 0;
				}
			}
		}
		while ( bufferPositionFormattedTextNoWhitespaces >= formattedTextNoWhitespaces.length()-1 && currentMetaText != null) {
			result.append(currentMetaText.getText());
			metaTexts.remove(currentMetaText);
			if (metaTexts.iterator().hasNext()) {
				currentMetaText = metaTexts.iterator().next();
			} else {
				currentMetaText = null;
			}
		}

		
		buf = result;
	}
	
	protected void metaText(String str) {
		MetaTextEntry metaTextEntry = new MetaTextEntry(str, buf.toString().replaceAll("[ \t\n\r]", "").length());
		metaTexts.add(metaTextEntry);
	}

	protected void textTransformed(String original, String transformed) {
		MetaTextEntry metaText = new MetaTextEntry(original, transformed, buf.toString().replaceAll("[ \t\n\r]", "").length());
		transformedTexts.add(metaText);
		buf.append(original);
		newLineOffsetCounter += original.length();
	}
	
	protected void newLine() {
		buf.append("\n");
		if (!isParagraphOpen) {
			metaText("\n<p class=PL style='mso-pagination:widow-orphan lines-together;page-break-after: avoid'>\n");
			isParagraphOpen = true;
		} else {
			metaText("\n</p>\n");
			isParagraphOpen = false;
		}
		openParagraph();

		if ((ruleSpacingStack != null) && (!ruleSpacingStack.empty())) {
			newLineOffsetCounter = ruleSpacingStack.peek();
		} else {
			newLineOffsetCounter = 0;
		}
	}
	
	protected void space() {
		metaText("<span style='mso-spacerun:yes'>&nbsp;</span>");
		buf.append(" ");
		newLineOffsetCounter++;
	}
	
	protected void spaces(int count) {
		metaText("<span style='mso-spacerun:yes'>");
		buf.append(" ");
		for (int i=0; i < count; i++) {
			metaText("&nbsp;");
		}
		metaText("</span>");
	}
	
	protected void wrap() {
		if ((config.isWrapAfterThreshold()) && (newLineOffsetCounter > config.getWrapThreshold())) {
			char last = buf.toString().charAt(buf.toString().length()-1);
			if (!((last == '(' || last == '[' || last == '{' ))) {
				newLine();
				newLine();
				if (ruleSpacingStack.size() > 1)
					spaces(ruleSpacingStack.peek() + 1);
				else
					spaces(ruleSpacingStack.peek());
			}
		}
	}
	
	private void closeOpenParagraph() {
		if (isParagraphOpen) {
			metaText("\n</p>\n");
			isParagraphOpen = false;
		}
	}

	private void openParagraph() {
		if (!isParagraphOpen) {
			metaText("\n<p class=PL style='mso-pagination:widow-orphan lines-together;page-break-after: avoid'>\n");
			isParagraphOpen = true;
		}
	}
	// -----------------------------------------------------------------------------
	
	protected void visitBefore(EtsiBnf node) {
		parserEtsiBnfNode = NodeUtil.getNodeAdapter(node).getParserNode();
		collectAllComments(parserEtsiBnfNode);
		originalText = NodeUtil.getNodeAdapter(node).getParserNode().serialize();
		originalTextNoWhitespaces = originalText.replaceAll("[ \t\n\r]", "");
		
		textTransformed("grammar " + node.getName(), "");
		if (node.getType() != null)
			textTransformed(node.getType(), "");
		textTransformed(";", "");
//		metaText("<body lang=EN-US link=blue vlink=purple style='tab-interval:14.15pt'>");
//		metaText("<div class=WordSection1>");
//		System.out.println("call!!!");
		
//		newLine();
//		newLine();
	}
	
	protected void visitAfter(EtsiBnf node) {
		closeOpenParagraph();
		
		metaText("</div>\n");
		metaText("</body>\n");
		metaText("</html>\n");
		weaveComments();
	}

	protected void visitBefore(Import node) {
		textTransformed("import \"" + node.getImportURI() + "\"","");
		if (node.getGrammarType() != null) {
			textTransformed("/" + node.getGrammarType(), "");
		}
		if (node.getLabel() != null) {
			space();
			textTransformed("label: " + node.getLabel(), "");
		}
		textTransformed(";", "");
//		text("\n");
	}
	
	protected void visitBefore(SectionHeading node) {
		if (!lastWasSectionHeading && !buf.substring(buf.length()-2).equals("\n\n"))
			newLine();
		
		lastWasSectionHeading=true;
		
		metaText("<h3><span lang=EN-GB>\n");
		String text = node.getSectionHeader().replaceAll("[\n\r]", "");
		textTransformed(text, StringEscapeUtils.escapeHtml(text).replaceAll("[\n\r]", ""));
//		textTransformed(text, text.replaceAll("[\t]", "\\<span style='mso-tab-count:1'\\>"));
		metaText("\n</span></h3>\n");
	}

	protected void visitAfter(SectionHeading node) {
//		newLine();
		closeOpenParagraph();
	}

	protected void visitBefore(RuleReference node) {
		wrap();
		
		String prefix = "<u><span style='color:blue'><a href=\"#T" + node.getRuleref().getName().replaceAll("[ \t\n\r]","") + "\">"; 
//		metaText(prefix);
		textTransformed(node.getRuleref().getName(), prefix + node.getRuleref().getName().replaceAll("[ \t\n\r]", "") + "</a></span></u>");
	}

	protected void visitAfter(RuleReference node) {
	}

	protected void visitBefore(Rule node) {
//		if (lastWasSectionHeading)
		
		newLine();
		
		lastWasSectionHeading=false;

		newLineOffsetCounter = 0;

		if (node.getRulenumber() > 0)
			text(node.getRulenumber() + ". ");

		String prefix = "<span lang=EN-GB style='mso-no-proof:no'><a name=\"T" + node.getName() + "\">"; 
//		metaText(prefix);
		textTransformed(node.getName(), prefix + node.getName().replaceAll("[ \t\r\n]", "") + "</a>");
//		metaText("</a>");
		text(" ::= ");
		
		rightHandSideRuleOffset = newLineOffsetCounter;
		ruleSpacingStack.push(newLineOffsetCounter);
	}
	
	protected void visitAfter(Rule node) {
		metaText("<o:p></o:p>\n</span>");
		text(";");
		newLine();
		text("\n");
		ruleSpacingStack.pop();
	}
	
	protected void visitBefore(StringRule node) {
		wrap();
		if (node.getLiteral() != null) {
//			text("\"" + node.getLiteral() + "\"");
			textTransformed("\"" + node.getLiteral() + "\"", StringEscapeUtils.escapeHtml("\"" + node.getLiteral() + "\"").replaceAll("[ \t\n\r]", "").trim());
//			textTransformed("\"" + node.getLiteral() + "\"", "gnabar");
		} else if (node.getColon() != null) {
//			text("\"\"\"");
			textTransformed("\"\"\"", StringEscapeUtils.escapeHtml("\"\"\"").replaceAll("[ \t\n\r]", "").trim());
//			textTransformed("\"\"\"", "gnabar");
		}
	}

	protected void visitAfter(StringRule node) {
	}
	
	protected void visitAfter(Term node) {
		if (!isLastElement()) {
			metaText("<span style='mso-spacerun:yes'>&nbsp;</span>");
			newLineOffsetCounter++;
//			space();
		}
	}

}
