package de.ugoe.cs.swe.bnftools.ui.preferences;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import de.ugoe.cs.swe.bnftools.ui.EbnfUiModule;

public class ValidationPreferencePage extends FieldEditorPreferencePage
		implements IWorkbenchPreferencePage {

	@Override
	protected void createFieldEditors() {
		addField(new BooleanFieldEditor("RULE_REFERENCED_ONLY_ONCE",
				"&Rule referenced only once", getFieldEditorParent()));
		addField(new BooleanFieldEditor("PASSTHROUGH_RULE",
				"&Passthrough rule", getFieldEditorParent()));
		addField(new BooleanFieldEditor("UNUSED_RULE",
				"&Unused rule", getFieldEditorParent()));
		addField(new BooleanFieldEditor("EQUAL_ALTERNATIVES_RULE",
				"&Rule with equal alternatives", getFieldEditorParent()));
		addField(new BooleanFieldEditor("CHECK_DUPLICATE_RULES",
				"&Duplicate Rules", getFieldEditorParent()));
		addField(new BooleanFieldEditor("CHECK_SUBRULE_DUPLICATES",
				"&Subrule Duplicates", getFieldEditorParent()));
		addField(new BooleanFieldEditor("CHECK_UPDATED_GRAMMAR_CONSISTENCY",
				"&Updated Grammar Consistency (in delta grammar)", getFieldEditorParent()));
	}

	public void init(IWorkbench workbench) {
		setPreferenceStore(de.ugoe.cs.swe.bnftools.ui.internal.EbnfActivator.getInstance().getPreferenceStore());
		setDescription("Enable or disable validation rules");
	}
	
    public boolean performOk() {
    	boolean result = super.performOk();
		EbnfUiModule.updateValidatorSettings(); // must be updated for each new validation rule!
    	return result;
    }
    
}
