package de.ugoe.cs.swe.bnftools.ui.refactoring.autorenumber;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.XtextDocument;

import de.ugoe.cs.swe.bnftools.ui.refactoring.generic.GenericRefactoring;
import de.ugoe.cs.swe.bnftools.ui.refactoring.generic.GenericRefactoringWizard;
import de.ugoe.cs.swe.bnftools.utils.RootEObjectFinder;

public class AutoRenumberRefactoringHandler extends AbstractHandler {

	public Object execute(ExecutionEvent event) throws ExecutionException {
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
		.getActiveWorkbenchWindow().getActivePage().getActiveEditor();

//TODO: better error handling		
		if (!(editor.getDocument() instanceof XtextDocument)) {
			return null;
		}
		
		XtextDocument doc = (XtextDocument) editor.getDocument();
		EObject root = doc.readOnly(new RootEObjectFinder());
		NodeAdapter rootNode = NodeUtil.getNodeAdapter(root);
		
		AutoRenumberRefactoringProcessor processor = new AutoRenumberRefactoringProcessor(
				editor, rootNode.getParserNode(), doc);

		GenericRefactoring refactoring = new GenericRefactoring(processor);
		
		GenericRefactoringWizard wizard = new GenericRefactoringWizard(
				refactoring, RefactoringWizard.WIZARD_BASED_USER_INTERFACE);

		RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation(
				wizard);

		try {
			openOperation.run(Display.getCurrent().getActiveShell(),
					"Refactoring not possible!");
		} catch (InterruptedException e1) {
			e1.printStackTrace();
		}
		
		return null;
	}


}
