package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;

public class TerminalFigure extends SyntaxDiagramFigure {
	private String terminalString;

	public TerminalFigure(String terminalString) {
		super();
		this.terminalString = terminalString;

		SyntaxDiagramFigure innerFigure = new SyntaxDiagramFigure();
		setBorder(new LineMarginBorder(0, 0, 0));
		innerFigure.setLayoutManager(new StackLayout());
		
	    FlowLayout layout = new FlowLayout();
	    layout.setMajorAlignment(FlowLayout.ALIGN_CENTER);
	    setLayoutManager(layout);	

		RoundedRectangle rectangle = new RoundedRectangle();
		rectangle.setAntialias(SWT.ON);
		rectangle.setCornerDimensions(new Dimension(16,16));
		rectangle.setBackgroundColor(new Color(null, 250, 210, 210));
		rectangle.setForegroundColor(new Color(null, 250, 180, 180));
		innerFigure.add(rectangle);

		Label terminalStringLabel = new Label(this.terminalString);
		terminalStringLabel.setForegroundColor(new Color(null, 0, 0, 200));
		terminalStringLabel.setTextAlignment(PositionConstants.CENTER);
		terminalStringLabel.setBorder(new MarginBorder(3,8,3,8));
		innerFigure.add(terminalStringLabel);
		
		PathFigure leftPath = new PathFigure();
		leftPath.setSourceAnchor(this.getLeftAnchor());
		leftPath.setTargetAnchor(innerFigure.getLeftAnchor());

		PathFigure rightPath = new PathFigure();
		rightPath.setTargetDecoration(null);
		rightPath.setSourceAnchor(innerFigure.getRightAnchor());
		rightPath.setTargetAnchor(this.getRightAnchor());
		
		add(leftPath);
		add(rightPath);
		
		add(innerFigure);
	}

	public String getTerminalString() {
		return terminalString;
	}

	public void setTerminalString(String terminalString) {
		this.terminalString = terminalString;
	}

}
