package de.ugoe.cs.swe.bnftools.ui.actions;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.xtext.parsetree.AbstractNode;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.LeafNode;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.Import;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.impl.EtsiBnfImpl;

public class PackageConsistencyCheckerAction extends ActionDelegate {
	private IStructuredSelection selection = StructuredSelection.EMPTY;
	private IFile file=null;
	private XtextResource coreResource = null;
	private XtextResource updatedResource = null;
	
	@Override
	public void run(IAction action) {
		TreeSelection treeSelection = (TreeSelection) selection;
		TreePath[] paths = treeSelection.getPaths();

		for (int i = 0; i < paths.length; i++) {
			TreePath path = paths[i];
			IFile f = (IFile) path.getLastSegment();
			XtextResourceSet set = new XtextResourceSet();
			String fp = f.getFullPath().toString();
			URI uri = URI.createPlatformResourceURI(fp,true); 

			Resource resource = set.getResource(uri, true);
			if (resource instanceof XtextResource) {
				
				XtextResource xtextResource = (XtextResource) resource;
				CompositeNode compNode = xtextResource.getParseResult().getRootNode();
				Iterable<AbstractNode> allNodes = NodeUtil.getAllContents(compNode);
				
				if(!((EtsiBnfImpl) xtextResource.getParseResult().getRootNode().getElement()).getType().equals("/delta"))
					continue;
				
				Resource coreRes = null;
				Resource updatedRes = null;
				EList<Import> imports = ((EtsiBnfImpl) xtextResource.getParseResult().getRootNode().getElement()).getImports();
				
				for(int j=0; j<imports.size(); j++) {
					if(imports.get(j).getGrammarType().equals("core")) {
						String packageUri = uri.trimSegments(1).toPlatformString(true);
						String fullUri = packageUri + "/" +imports.get(j).getImportURI();
						coreRes= set.getResource( URI.createPlatformResourceURI(fullUri, true), true);
					}
					if(imports.get(j).getGrammarType().equals("update")) {
						String packageUri = uri.trimSegments(1).toPlatformString(true);
						String fullUri = packageUri + "/" +imports.get(j).getImportURI();
						updatedRes= set.getResource( URI.createPlatformResourceURI(fullUri, true), true);
					}
					
					
				}
				if( (coreRes==null) || (updatedRes==null))
					return;
				
				if(coreRes instanceof XtextResource)
					coreResource = (XtextResource) coreRes;
				if(updatedRes instanceof XtextResource)
					updatedResource = (XtextResource) updatedRes;
				
				InputDialog di = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Name Selection", 
						"Please type a name for the consistency check file.", uri.trimFileExtension().segment(uri.segmentCount()-1) + "_cons.txt", null);
				di.open();
				String fname = di.getValue();
				
				String loc = uri.trimSegments(1).toPlatformString(true); //uri.trimFileExtension().trimSegments(1).toPlatformString(true);
				loc = loc.concat("/" + fname);
				IPath filePath = new Path(loc);
				file = ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
				   
				   try {
				   if (!file.exists()) {
				      byte[] bytes = ("Consistency check for: " + uri.trimFileExtension().segment(uri.segmentCount()-1) + '\n').getBytes();
				      InputStream source = new ByteArrayInputStream(bytes);
				      file.create(source, IResource.NONE, null);				      
				   }
				   else return;
				   	} catch (CoreException e) {
						e.printStackTrace();
					}
				createNewLine("The only rules shown are the ones that were found inconsistent between the two versions." + '\n');
				
				/*
				 * the idea: get the core grammar and the updated grammar
				 * for each extension rule in the delta grammar,
				 * 		find the corresponding rule in the updated grammar and the core grammar
				 * 		if it doesn't exist in the updated grammar write the inconsistency
				 * 		if it exists, compare to the rule in the core grammar
				 */
				for(AbstractNode node: allNodes) {
					if(node.getElement() instanceof ExtRule) {
							if(!checkForConsistency(node))
								createNewLine("Extension Rule: " + node.serialize().trim()+'\n' + '\n');
						
					}
						
				}
				

					
				
			}
		}
	}
	
	private boolean checkForConsistency(AbstractNode node) {
		//updated grammar:
		AbstractNode updatedRule = null;
		AbstractNode coreRule = null;
		for(AbstractNode uNode : NodeUtil.getAllContents(updatedResource.getParseResult().getRootNode())) {
			if(uNode.getElement() instanceof Rule)
				if(((Rule) uNode.getElement()).getName().equals(((ExtRule) node.getElement()).getName())) {
					updatedRule = uNode;
					break;
				}
		}
		
		if(updatedRule == null){
			createNewLine("The following core grammar rule used in the package does not exist in the updated grammar: \n");
			return false;
		}
		
		//core grammar:
		else {
			for(AbstractNode cNode : NodeUtil.getAllContents(coreResource.getParseResult().getRootNode())) {
				if(cNode.getElement() instanceof Rule)
					if(((Rule) cNode.getElement()).getName().equals(((ExtRule) node.getElement()).getName())) {
						coreRule = cNode;
						break;
					}
			}
			
			if(coreRule == null){
				createNewLine("Error at the following rule: (no corresponding rule found in the core grammar!):" + '\n');
				return false;
			}
			
			if(compareRules(coreRule, updatedRule))
				return true;
			else {
				createNewLine("Inconsistency found at the following rule:" + '\n');
				createNewLine("Core Rule: ");
				createNewLine(coreRule.serialize().trim()+ '\n');
				createNewLine("Updated Rule: ");
				createNewLine(updatedRule.serialize().trim() + '\n');

				return false;
			}
			
		}
	}
	
	
	//returns true, if the rules are equal
	private boolean compareRules(AbstractNode cNode, AbstractNode uNode) {
		EList<LeafNode> cLeaves = removeWS(cNode.getLeafNodes());
		EList<LeafNode> uLeaves = removeWS(uNode.getLeafNodes());
		if(cLeaves.size()!=uLeaves.size())
			return false;
		
		for(int i=0; i< cLeaves.size(); i++) {
			if(!(cLeaves.get(i).serialize().equals(uLeaves.get(i).serialize())))
				return false;
		}
		return true;
	}
	

	private EList<LeafNode> removeWS(EList<LeafNode> leaves) {
		for(int i=0; i<leaves.size(); i++) {
			if(!(leaves.get(i).getGrammarElement() instanceof org.eclipse.xtext.impl.TerminalRuleImpl))
				leaves.remove(i);
		}
		return leaves;
	}
	
	private boolean checkReferences(AbstractNode rule){
		EList<EObject> refs = rule.getElement().eContents();
		for(int i=0; i<refs.size(); i++){
			if(refs.get(i) instanceof RuleReference)
				System.out.println(refs.get(i));
		}
//		EList<LeafNode> references = ruleref(removeWS(rule.getLeafNodes()));
//		for(int i=0; i<references.size(); i++)
//			if(references.get(i).getElement() instanceof RuleReference)
//			System.out.println(references.get(i));

		return false;
	}
	
	
	
	private void createNewLine(String rule) {
		try {
			   if (file.exists()) {
			      byte[] bytes = (rule).getBytes();
			      InputStream source = new ByteArrayInputStream(bytes);
			      file.appendContents(source, IResource.NONE, null);
			   }
			   	} catch (CoreException e) {
					e.printStackTrace();
			}
	}
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if (selection instanceof IStructuredSelection) {
			this.selection = (IStructuredSelection) selection;
		} else {
			this.selection = StructuredSelection.EMPTY;
		}
	}

}
