package de.ugoe.cs.swe.bnftools.ui.quickfix;

import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.quickfix.DefaultQuickfixProvider;
import org.eclipse.xtext.ui.editor.quickfix.Fix;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionAcceptor;
import org.eclipse.xtext.validation.Issue;
import com.google.inject.Inject;
import de.ugoe.cs.swe.bnftools.ui.quickfix.modifications.InlineRuleModification;
import de.ugoe.cs.swe.bnftools.ui.quickfix.modifications.RemovePassthroughRuleModification;
import de.ugoe.cs.swe.bnftools.ui.quickfix.modifications.RemoveUnusedRuleModification;
import de.ugoe.cs.swe.bnftools.validation.EbnfJavaValidator;

public class EbnfQuickfixProvider extends DefaultQuickfixProvider {

	@Inject
	IResourceDescriptions resourceDescriptions;

	// ----------------------------------------------------------------------------------------------------

	@Fix(value = EbnfJavaValidator.ruleReferencedOneDescription)
	public void fixInlineRuleReferencedOnce(final Issue issue, IssueResolutionAcceptor acceptor) {
		InlineRuleModification inlineRuleModification = new InlineRuleModification(
				resourceDescriptions);

		acceptor.accept(
				issue,
				"Inline the rule",
				"Delete the rule and replace its single reference by the rule's right side",
				"upcase.png", inlineRuleModification);
	}

	// ----------------------------------------------------------------------------------------------------

	@Fix(value = EbnfJavaValidator.passthroughRuleDescription)
	public void fixRemovePassthroughRule(final Issue issue, IssueResolutionAcceptor acceptor) {
		RemovePassthroughRuleModification removePassthroughRuleModification = new RemovePassthroughRuleModification(
				resourceDescriptions);

		acceptor.accept(
				issue,
				"Remove passthrough rule",
				"Delete the passthrough rule and replace its references with its right side",
				"upcase.png", removePassthroughRuleModification);
	}

	// ----------------------------------------------------------------------------------------------------

	@Fix(value = EbnfJavaValidator.unusedRuleDescription)
	public void fixUnusedRule(final Issue issue, IssueResolutionAcceptor acceptor) {
		RemoveUnusedRuleModification removeUnusedRuleModification = new RemoveUnusedRuleModification(
				resourceDescriptions);

		acceptor.accept(
				issue,
				"Remove unused rule",
				"Delete the unused rule",
				"upcase.png", removeUnusedRuleModification);
	}

}
