package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;

import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;

public class RepetitionFigure extends SyntaxDiagramFigure {
	
	private BorderLayout layout;

	public RepetitionFigure(SyntaxDiagramFigure repetitionFigure) {
		layout = new BorderLayout();
		
		setLayoutManager(layout);
		addFigure(repetitionFigure);
		setBorder(new LineMarginBorder(10,40,10,40,0));
	}

	private void addFigure(SyntaxDiagramFigure f) {
		SyntaxDiagramFigure upperContainer = new SyntaxDiagramFigure();
		//upperContainer.setBorder(new LineBorder());
		upperContainer.setLayoutManager(new ToolbarLayout());
		upperContainer.setVisible(true);
		add(upperContainer, BorderLayout.TOP);
		setLeftAnchor(new SideAnchor(this, upperContainer.getLeftAnchor(), SideAnchor.LEFT_SIDE));
		setRightAnchor(new SideAnchor(this, upperContainer.getRightAnchor(), SideAnchor.RIGHT_SIDE));
		layout.setConstraint(upperContainer, BorderLayout.TOP);

		SyntaxDiagramFigure centerContainer = new SyntaxDiagramFigure();
		//centerContainer.setBorder(new LineBorder());
		ToolbarLayout loopLayout = new ToolbarLayout();
		loopLayout.setStretchMinorAxis(false);
		loopLayout.setMinorAlignment(ToolbarLayout.ALIGN_CENTER);
		loopLayout.setVertical(true);
		centerContainer.setLayoutManager(loopLayout);
		centerContainer.setPreferredSize(new Dimension(50,40));
		//centerContainer.setForegroundColor(new Color(null,new RGB(255,0,0)));
		centerContainer.setVisible(true);
		add(centerContainer, BorderLayout.CENTER);
		layout.setConstraint(centerContainer, BorderLayout.CENTER);
		
		upperContainer.add(f);

		PathFigure leftPath = new PathFigure();
		leftPath.setTargetDecoration(null);
		leftPath.setSourceAnchor(this.getLeftAnchor());
		leftPath.setTargetAnchor(f.getLeftAnchor());
		add(leftPath);

		PathFigure rightPath = new PathFigure();
		rightPath.setTargetDecoration(null);
		rightPath.setSourceAnchor(f.getRightAnchor());
		rightPath.setTargetAnchor(this.getRightAnchor());
		add(rightPath);

		PathFigure rightLoopPath = new PathFigure();
		rightLoopPath.setSourceAnchor(upperContainer.getRightAnchor());
		rightLoopPath.setTargetAnchor(centerContainer.getRightAnchor());
		add(rightLoopPath);

		PathFigure leftLoopPath = new PathFigure();
		leftLoopPath.setSourceAnchor(centerContainer.getLeftAnchor());
		leftLoopPath.setTargetAnchor(upperContainer.getLeftAnchor());
		add(leftLoopPath);
		
		SyntaxDiagramFigure dummy = new SyntaxDiagramFigure();
		dummy.setBorder(new LineBorder());
		dummy.setForegroundColor(ColorConstants.blue);
		dummy.setLeftAnchor(new SideAnchor(dummy, centerContainer.getLeftAnchor(),SideAnchor.LEFT_SIDE));
		dummy.setRightAnchor(new SideAnchor(dummy, centerContainer.getRightAnchor(),SideAnchor.RIGHT_SIDE));
		dummy.setPreferredSize(-1, centerContainer.getPreferredSize().height);
		dummy.setVisible(true);
		centerContainer.add(dummy, BorderLayout.CENTER);
		
		PathFigure leftMainLoopPath = new PathFigure();
//		leftMainLoopPath.setTargetDecoration(null);
		leftMainLoopPath.setSourceAnchor(centerContainer.getRightAnchor());
		leftMainLoopPath.setTargetAnchor(dummy.getRightAnchor());
		centerContainer.add(leftMainLoopPath);

		PathFigure rightMainLoopPath = new PathFigure();
//		rightMainLoopPath.setTargetDecoration(null);
		rightMainLoopPath.setSourceAnchor(dummy.getLeftAnchor());
		rightMainLoopPath.setTargetAnchor(centerContainer.getLeftAnchor());
		centerContainer.add(rightMainLoopPath);
	}
	
}
