package de.ugoe.cs.swe.bnftools.ui.views.syntaxdiagram;
import org.eclipse.draw2d.AbstractConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;

class SideAnchor extends AbstractConnectionAnchor {

	public static int LEFT_SIDE = 1;
	public static int RIGHT_SIDE = 2;
	private int side = LEFT_SIDE;
	private SideAnchor heightRef = null;
	
	public SideAnchor(IFigure owner, int side) {
		super(owner);
		this.side = side;
	}

	public SideAnchor(IFigure owner, SideAnchor heightRef, int side) {
		super(owner);
		this.side = side;
		this.heightRef = heightRef;
	}
	
	public Point getLocation(Point loc) {
		Rectangle r = getOwner().getBounds();
		int x,y;
		
		if (side == SideAnchor.LEFT_SIDE) {
			x = r.x ;
			
		} else {
			x = r.x + r.width;
		}
		if (heightRef == null) {
			y = r.y + r.height/2 ;
		} else {
			Rectangle heightBounds = heightRef.getOwner().getBounds();
			y = heightBounds.y + heightBounds.height/2;
		}

		Point p = new PrecisionPoint(x, y);
		getOwner().translateToAbsolute(p);

		return p;
	}
}
