package de.ugoe.cs.swe.bnftools.ui.quickfix.modifications;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.parsetree.CompositeNode;
import org.eclipse.xtext.parsetree.NodeAdapter;
import org.eclipse.xtext.parsetree.NodeUtil;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.edit.IModificationContext;
import org.eclipse.xtext.ui.editor.model.edit.ISemanticModification;

import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ui.quickfix.processors.ReplacePassthroughRuleProcessor;
import de.ugoe.cs.swe.bnftools.utils.DeclarationReferencesPair;
import de.ugoe.cs.swe.bnftools.utils.Utils;

public class RemovePassthroughRuleModification implements ISemanticModification {

	IResourceDescriptions resourceDescriptions;

	// ----------------------------------------------------------------------------------------------------

	public RemovePassthroughRuleModification(
			IResourceDescriptions resourceDescriptions) {
		this.resourceDescriptions = resourceDescriptions;
	}

	// ----------------------------------------------------------------------------------------------------

	public void apply(EObject element, IModificationContext context)
			throws Exception {
		// get current editor
		XtextEditor editor = (XtextEditor) PlatformUI.getWorkbench()
				.getActiveWorkbenchWindow().getActivePage().getActiveEditor();
		Rule rule = (Rule) element;

		NodeAdapter declarationNode = NodeUtil.getNodeAdapter(rule);
		
		List<CompositeNode> references = Utils.findReferences(element,
				resourceDescriptions, editor);

		System.out.println(references);
		
		List<DeclarationReferencesPair> nodePairs = new ArrayList<DeclarationReferencesPair>();
		nodePairs.add(new DeclarationReferencesPair((CompositeNode) declarationNode.getParserNode(), references));
		
		ReplacePassthroughRuleProcessor processor = new ReplacePassthroughRuleProcessor(
				editor, editor.getDocument(), nodePairs, true);

		NullProgressMonitor pm = new NullProgressMonitor();
		Change change;
		try {
			change = processor.createChange(pm);
			change.initializeValidationData(pm);
			change.setEnabled(true);
			PerformChangeOperation operation = new PerformChangeOperation(
					change);
			operation.setUndoManager(RefactoringCore.getUndoManager(),
					processor.getProcessorName());
			operation.run(pm);
			change.dispose();
		} catch (Exception e) {
			e.printStackTrace();
		}

	}

}
