/*
 * generated by Xtext
 */
package de.ugoe.cs.swe.bnftools.formatting

import com.google.inject.Inject
import de.ugoe.cs.swe.bnftools.services.EbnfGrammarAccess
import org.eclipse.xtext.Keyword
import org.eclipse.xtext.formatting.impl.AbstractDeclarativeFormatter
import org.eclipse.xtext.formatting.impl.FormattingConfig
import org.eclipse.emf.ecore.EObject
import de.ugoe.cs.swe.bnftools.ebnf.Rule
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList

/**
 * This class contains custom formatting description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#formatting
 * on how and when to use it 
 * 
 * Also see {@link org.eclipse.xtext.xtext.XtextFormattingTokenSerializer} as an example
 */
class EbnfFormatter extends AbstractDeclarativeFormatter {

	@Inject extension EbnfGrammarAccess

	override protected void configureFormatting(FormattingConfig c) {

		// They will add and preserve newlines around comments
		c.setLinewrap(0, 1, 2).before(SL_COMMENTRule)
		c.setLinewrap(0, 1, 2).before(ML_COMMENTRule)
		c.setLinewrap(0, 1, 1).after(ML_COMMENTRule)

		var EbnfGrammarAccess f = getGrammarAccess as EbnfGrammarAccess;
		c.setLinewrap.before(f.ruleRule);
		c.setLinewrap.before(f.importRule);
		c.setNoSpace.after(f.ruleAccess.rulenumberINTTerminalRuleCall_0_0_0)

		
//		for (Keyword bar : f.findKeywords("|")) {
//
//			c.setSpace("\n\t\t").before(bar);
//		}

	}
}
