package de.ugoe.cs.swe.bnftools.serializer;

import com.google.inject.Inject;
import com.google.inject.Provider;
import de.ugoe.cs.swe.bnftools.ebnf.Atom;
import de.ugoe.cs.swe.bnftools.ebnf.BnfEntry;
import de.ugoe.cs.swe.bnftools.ebnf.DefinitionList;
import de.ugoe.cs.swe.bnftools.ebnf.DeltaEntry;
import de.ugoe.cs.swe.bnftools.ebnf.EbnfPackage;
import de.ugoe.cs.swe.bnftools.ebnf.EtsiBnf;
import de.ugoe.cs.swe.bnftools.ebnf.ExtRule;
import de.ugoe.cs.swe.bnftools.ebnf.GlobalCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.GroupedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.HookCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.Import;
import de.ugoe.cs.swe.bnftools.ebnf.ImportSection;
import de.ugoe.cs.swe.bnftools.ebnf.MergeEntry;
import de.ugoe.cs.swe.bnftools.ebnf.OptionalSequence;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatRange;
import de.ugoe.cs.swe.bnftools.ebnf.RepeatedSequence;
import de.ugoe.cs.swe.bnftools.ebnf.Rule;
import de.ugoe.cs.swe.bnftools.ebnf.RuleCombinator;
import de.ugoe.cs.swe.bnftools.ebnf.RuleReference;
import de.ugoe.cs.swe.bnftools.ebnf.SectionHeading;
import de.ugoe.cs.swe.bnftools.ebnf.SingleDefinition;
import de.ugoe.cs.swe.bnftools.ebnf.StringRule;
import de.ugoe.cs.swe.bnftools.ebnf.Term;
import de.ugoe.cs.swe.bnftools.services.EbnfGrammarAccess;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.serializer.acceptor.ISemanticSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.SequenceFeeder;
import org.eclipse.xtext.serializer.diagnostic.ISemanticSequencerDiagnosticProvider;
import org.eclipse.xtext.serializer.diagnostic.ISerializationDiagnostic.Acceptor;
import org.eclipse.xtext.serializer.sequencer.AbstractDelegatingSemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.GenericSequencer;
import org.eclipse.xtext.serializer.sequencer.ISemanticNodeProvider.INodesForEObjectProvider;
import org.eclipse.xtext.serializer.sequencer.ISemanticSequencer;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService;
import org.eclipse.xtext.serializer.sequencer.ITransientValueService.ValueTransient;

@SuppressWarnings("all")
public class EbnfSemanticSequencer extends AbstractDelegatingSemanticSequencer {

	@Inject
	private EbnfGrammarAccess grammarAccess;
	
	public void createSequence(EObject context, EObject semanticObject) {
		if(semanticObject.eClass().getEPackage() == EbnfPackage.eINSTANCE) switch(semanticObject.eClass().getClassifierID()) {
			case EbnfPackage.ATOM:
				if(context == grammarAccess.getAtomRule()) {
					sequence_Atom(context, (Atom) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.BNF_ENTRY:
				if(context == grammarAccess.getBnfEntryRule()) {
					sequence_BnfEntry(context, (BnfEntry) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.DEFINITION_LIST:
				if(context == grammarAccess.getDefinitionListRule()) {
					sequence_DefinitionList(context, (DefinitionList) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.DELTA_ENTRY:
				if(context == grammarAccess.getDeltaEntryRule()) {
					sequence_DeltaEntry(context, (DeltaEntry) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.ETSI_BNF:
				if(context == grammarAccess.getEtsiBnfRule()) {
					sequence_EtsiBnf(context, (EtsiBnf) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.EXT_RULE:
				if(context == grammarAccess.getExtRuleRule()) {
					sequence_ExtRule(context, (ExtRule) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.GLOBAL_COMBINATOR:
				if(context == grammarAccess.getGlobalCombinatorRule() ||
				   context == grammarAccess.getMergeRuleRule()) {
					sequence_GlobalCombinator(context, (GlobalCombinator) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.GROUPED_SEQUENCE:
				if(context == grammarAccess.getGroupedSequenceRule()) {
					sequence_GroupedSequence(context, (GroupedSequence) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.HOOK_COMBINATOR:
				if(context == grammarAccess.getHookCombinatorRule() ||
				   context == grammarAccess.getMergeRuleRule()) {
					sequence_HookCombinator(context, (HookCombinator) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.IMPORT:
				if(context == grammarAccess.getImportRule()) {
					sequence_Import(context, (Import) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.IMPORT_SECTION:
				if(context == grammarAccess.getImportSectionRule()) {
					sequence_ImportSection(context, (ImportSection) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.MERGE_ENTRY:
				if(context == grammarAccess.getMergeEntryRule()) {
					sequence_MergeEntry(context, (MergeEntry) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.OPTIONAL_SEQUENCE:
				if(context == grammarAccess.getOptionalSequenceRule()) {
					sequence_OptionalSequence(context, (OptionalSequence) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.REPEAT_RANGE:
				if(context == grammarAccess.getRepeatRangeRule()) {
					sequence_RepeatRange(context, (RepeatRange) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.REPEATED_SEQUENCE:
				if(context == grammarAccess.getRepeatedSequenceRule()) {
					sequence_RepeatedSequence(context, (RepeatedSequence) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.RULE:
				if(context == grammarAccess.getRuleRule()) {
					sequence_Rule(context, (Rule) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.RULE_COMBINATOR:
				if(context == grammarAccess.getMergeRuleRule() ||
				   context == grammarAccess.getRuleCombinatorRule()) {
					sequence_RuleCombinator(context, (RuleCombinator) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.RULE_REFERENCE:
				if(context == grammarAccess.getRuleReferenceRule()) {
					sequence_RuleReference(context, (RuleReference) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.SECTION_HEADING:
				if(context == grammarAccess.getSectionHeadingRule()) {
					sequence_SectionHeading(context, (SectionHeading) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.SINGLE_DEFINITION:
				if(context == grammarAccess.getSingleDefinitionRule()) {
					sequence_SingleDefinition(context, (SingleDefinition) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.STRING_RULE:
				if(context == grammarAccess.getStringRuleRule()) {
					sequence_StringRule(context, (StringRule) semanticObject); 
					return; 
				}
				else break;
			case EbnfPackage.TERM:
				if(context == grammarAccess.getTermRule()) {
					sequence_Term(context, (Term) semanticObject); 
					return; 
				}
				else break;
			}
		if (errorAcceptor != null) errorAcceptor.accept(diagnosticProvider.createInvalidContextOrTypeDiagnostic(semanticObject, context));
	}
	
	/**
	 * Constraint:
	 *     (atomStringRule=StringRule | atomRuleReference=RuleReference)
	 */
	protected void sequence_Atom(EObject context, Atom semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (sectionheader=SectionHeading | rule=Rule)
	 */
	protected void sequence_BnfEntry(EObject context, BnfEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (singleDefinition+=SingleDefinition singleDefinition+=SingleDefinition*)
	 */
	protected void sequence_DefinitionList(EObject context, DefinitionList semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (rule=Rule | sectionheader=SectionHeading | extRule=ExtRule)
	 */
	protected void sequence_DeltaEntry(EObject context, DeltaEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (
	 *         (name=ID type='/bnf'? importSection=ImportSection? bnfEntry+=BnfEntry+) | 
	 *         (type='/delta' importSection=ImportSection? deltaEntry+=DeltaEntry*) | 
	 *         (type='/merge' importSection=ImportSection? mergeEntry+=MergeEntry*)
	 *     )
	 */
	protected void sequence_EtsiBnf(EObject context, EtsiBnf semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ((rulenumber=INT rulevariant=ID?)? name=ID ruleext=INT elements+=Atom*)
	 */
	protected void sequence_ExtRule(EObject context, ExtRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     logic=LOGIC
	 */
	protected void sequence_GlobalCombinator(EObject context, GlobalCombinator semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, EbnfPackage.Literals.MERGE_RULE__LOGIC) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EbnfPackage.Literals.MERGE_RULE__LOGIC));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getGlobalCombinatorAccess().getLogicLOGICTerminalRuleCall_1_0(), semanticObject.getLogic());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     definitionList+=DefinitionList
	 */
	protected void sequence_GroupedSequence(EObject context, GroupedSequence semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID ruleext=INT logic=LOGIC? LABEL+=STRING+)
	 */
	protected void sequence_HookCombinator(EObject context, HookCombinator semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     imports+=Import+
	 */
	protected void sequence_ImportSection(EObject context, ImportSection semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (importURI=STRING (grammarType='core' | grammarType='package' | grammarType='update')? label=ID?)
	 */
	protected void sequence_Import(EObject context, Import semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (sectionheader=SectionHeading | mergeRule=MergeRule)
	 */
	protected void sequence_MergeEntry(EObject context, MergeEntry semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     definitionList+=DefinitionList
	 */
	protected void sequence_OptionalSequence(EObject context, OptionalSequence semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (from=INT to=INT)
	 */
	protected void sequence_RepeatRange(EObject context, RepeatRange semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, EbnfPackage.Literals.REPEAT_RANGE__FROM) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EbnfPackage.Literals.REPEAT_RANGE__FROM));
			if(transientValues.isValueTransient(semanticObject, EbnfPackage.Literals.REPEAT_RANGE__TO) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EbnfPackage.Literals.REPEAT_RANGE__TO));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getRepeatRangeAccess().getFromINTTerminalRuleCall_2_0(), semanticObject.getFrom());
		feeder.accept(grammarAccess.getRepeatRangeAccess().getToINTTerminalRuleCall_4_0(), semanticObject.getTo());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     (definitions+=DefinitionList (morethanonce?='+'? | range=RepeatRange?))
	 */
	protected void sequence_RepeatedSequence(EObject context, RepeatedSequence semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (name=ID logic=LOGIC LABEL+=STRING*)
	 */
	protected void sequence_RuleCombinator(EObject context, RuleCombinator semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     ruleref=[Rule|ID]
	 */
	protected void sequence_RuleReference(EObject context, RuleReference semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, EbnfPackage.Literals.RULE_REFERENCE__RULEREF) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EbnfPackage.Literals.RULE_REFERENCE__RULEREF));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getRuleReferenceAccess().getRulerefRuleIDTerminalRuleCall_0_1(), semanticObject.getRuleref());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     ((rulenumber=INT rulevariant=ID?)? name=ID definitionList=DefinitionList?)
	 */
	protected void sequence_Rule(EObject context, Rule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     sectionHeader=SECTIONHEADER
	 */
	protected void sequence_SectionHeading(EObject context, SectionHeading semanticObject) {
		if(errorAcceptor != null) {
			if(transientValues.isValueTransient(semanticObject, EbnfPackage.Literals.SECTION_HEADING__SECTION_HEADER) == ValueTransient.YES)
				errorAcceptor.accept(diagnosticProvider.createFeatureValueMissing(semanticObject, EbnfPackage.Literals.SECTION_HEADING__SECTION_HEADER));
		}
		INodesForEObjectProvider nodes = createNodeProvider(semanticObject);
		SequenceFeeder feeder = createSequencerFeeder(semanticObject, nodes);
		feeder.accept(grammarAccess.getSectionHeadingAccess().getSectionHeaderSECTIONHEADERTerminalRuleCall_1_0(), semanticObject.getSectionHeader());
		feeder.finish();
	}
	
	
	/**
	 * Constraint:
	 *     terms+=Term+
	 */
	protected void sequence_SingleDefinition(EObject context, SingleDefinition semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (literal=STRING | colon=COLON)
	 */
	protected void sequence_StringRule(EObject context, StringRule semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
	
	
	/**
	 * Constraint:
	 *     (termAtom=Atom | termGroupedSequence=GroupedSequence | termOptionalSequence=OptionalSequence | termRepeatedSequence=RepeatedSequence)
	 */
	protected void sequence_Term(EObject context, Term semanticObject) {
		genericSequencer.createSequence(context, semanticObject);
	}
}
